/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.validation.rules.invalid.name;

import io.apicurio.datamodels.compat.RegexCompat;
import io.apicurio.datamodels.core.validation.ValidationRule;
import io.apicurio.datamodels.core.validation.ValidationRuleMetaData;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class OasInvalidPropertyNameRule
extends ValidationRule {
    private static final String DEFINITION_NAME_MATCH_REGEX = "^[a-zA-Z0-9\\.\\-_]+$";

    public OasInvalidPropertyNameRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    protected boolean isValidDefinitionName(String name) {
        return RegexCompat.matches(name, DEFINITION_NAME_MATCH_REGEX);
    }

    protected boolean isValidScopeName(String scope) {
        return true;
    }

    protected List<ValidationRule.PathSegment> findEmptySegmentsInPath(List<ValidationRule.PathSegment> pathSegments) {
        ArrayList<ValidationRule.PathSegment> emptySegments = new ArrayList<ValidationRule.PathSegment>();
        for (ValidationRule.PathSegment pathSegment : pathSegments) {
            if (!this.equals(pathSegment.prefix, "") || this.hasValue(pathSegment.formalName)) continue;
            emptySegments.add(pathSegment);
        }
        return emptySegments;
    }

    protected List<String> findDuplicateParametersInPath(List<ValidationRule.PathSegment> pathSegments) {
        LinkedHashMap counts = new LinkedHashMap();
        pathSegments.forEach(pathSegment -> {
            if (this.hasValue(pathSegment.formalName)) {
                int count = 0;
                if (counts.containsKey(pathSegment.formalName)) {
                    count = (Integer)counts.get(pathSegment.formalName);
                }
                counts.put(pathSegment.formalName, count + 1);
            }
        });
        ArrayList<String> rval = new ArrayList<String>();
        for (Map.Entry entry : counts.entrySet()) {
            if ((Integer)entry.getValue() <= 1) continue;
            rval.add((String)entry.getKey());
        }
        return rval;
    }
}

