/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.validation.rules.required;

import io.apicurio.datamodels.core.models.common.SecurityScheme;
import io.apicurio.datamodels.core.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.core.validation.rules.required.RequiredPropertyValidationRule;
import io.apicurio.datamodels.openapi.v2.models.Oas20SecurityScheme;

public class OasMissingOAuthSchemeTokenUrlRule
extends RequiredPropertyValidationRule {
    public OasMissingOAuthSchemeTokenUrlRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    @Override
    public void visitSecurityScheme(SecurityScheme node) {
        if (this.equals(node.type, "oauth2")) {
            Oas20SecurityScheme scheme = (Oas20SecurityScheme)node;
            if ((this.equals(scheme.flow, "password") || this.equals(scheme.flow, "application") || this.equals(scheme.flow, "accessCode")) && !this.isDefined(scheme.tokenUrl)) {
                this.report(scheme, "tokenUrl", this.map(new String[0]));
            }
        }
    }
}

