/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.openapi.visitors.dereference;

import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v2.models.Oas20Parameter;
import io.apicurio.datamodels.openapi.v2.models.Oas20ParameterDefinition;
import io.apicurio.datamodels.openapi.v2.models.Oas20Response;
import io.apicurio.datamodels.openapi.v2.models.Oas20ResponseDefinition;
import io.apicurio.datamodels.openapi.v2.models.Oas20Schema;
import io.apicurio.datamodels.openapi.v2.models.Oas20SchemaDefinition;
import io.apicurio.datamodels.openapi.visitors.dereference.AbstractReferenceLocalizationStrategy;
import io.apicurio.datamodels.openapi.visitors.dereference.IReferenceManipulationStrategy;
import java.util.LinkedHashMap;
import java.util.Map;

public class Oas20IReferenceManipulationStrategy
extends AbstractReferenceLocalizationStrategy
implements IReferenceManipulationStrategy {
    protected String PREFIX = "#/";

    @Override
    public IReferenceManipulationStrategy.ReferenceAndNode attachAsDefinition(Document document, String name, Node component) {
        if (!(document instanceof Oas20Document)) {
            throw new IllegalArgumentException("Oas20Document expected.");
        }
        Oas20Document model = (Oas20Document)document;
        if (component instanceof Oas20Schema) {
            if (model.definitions == null) {
                model.definitions = model.createDefinitions();
            }
            if (model.definitions.getDefinition(name) != null) {
                throw new IllegalArgumentException("Definition with that name already exists: " + name);
            }
            Oas20SchemaDefinition definition = this.wrap(component, new Oas20SchemaDefinition(name), model);
            definition.attachToParent(model.definitions);
            model.definitions.addDefinition(definition.getName(), definition);
            return new IReferenceManipulationStrategy.ReferenceAndNode(this.PREFIX + "definitions/" + name, definition);
        }
        if (component instanceof Oas20Parameter) {
            if (model.parameters == null) {
                model.parameters = model.createParameterDefinitions();
            }
            if (model.parameters.getParameter(name) != null) {
                throw new IllegalArgumentException("Definition with that name already exists: " + name);
            }
            Oas20ParameterDefinition definition = this.wrap(component, new Oas20ParameterDefinition(name), model);
            definition.attachToParent(model.parameters);
            model.parameters.addParameter(definition.getName(), definition);
            return new IReferenceManipulationStrategy.ReferenceAndNode(this.PREFIX + "parameters/" + name, definition);
        }
        if (component instanceof Oas20Response) {
            if (model.responses == null) {
                model.responses = model.createResponseDefinitions();
            }
            if (model.responses.getResponse(name) != null) {
                throw new IllegalArgumentException("Definition with that name already exists: " + name);
            }
            Oas20ResponseDefinition definition = this.wrap(component, new Oas20ResponseDefinition(name), model);
            definition.attachToParent(model.responses);
            model.responses.addResponse(definition.getName(), definition);
            return new IReferenceManipulationStrategy.ReferenceAndNode(this.PREFIX + "responses/" + name, definition);
        }
        return null;
    }

    @Override
    public Map<String, Node> getExistingLocalComponents(Document document) {
        if (!(document instanceof Oas20Document)) {
            throw new IllegalArgumentException("Oas20Document expected.");
        }
        Oas20Document model = (Oas20Document)document;
        LinkedHashMap<String, Node> res = new LinkedHashMap<String, Node>();
        if (model.definitions != null) {
            this.transform(model.definitions.items, name -> this.PREFIX + "definitions/" + name, res);
        }
        if (model.parameters != null) {
            this.transform(model.parameters.items, name -> this.PREFIX + "parameters/" + name, res);
        }
        if (model.responses != null) {
            this.transform(model.responses.items, name -> this.PREFIX + "responses/" + name, res);
        }
        return res;
    }
}

