/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.operators.UniSerializedSubscriber;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;

public class UniOrCombination<T>
extends UniOperator<Void, T> {
    private final List<Uni<? super T>> challengers;

    public UniOrCombination(Iterable<? extends Uni<? super T>> iterable) {
        super(null);
        this.challengers = new ArrayList<Uni<? super T>>();
        ParameterValidation.nonNull(iterable, "produceIterable").forEach(u -> this.challengers.add(ParameterValidation.nonNull(u, "iterable` must not contain a `null` value")));
    }

    public UniOrCombination(Uni<? super T>[] array) {
        super(null);
        ParameterValidation.nonNull(array, "array");
        this.challengers = new ArrayList<Uni<? super T>>();
        for (Uni<? super T> u : array) {
            this.challengers.add(ParameterValidation.nonNull(u, "array` must not contain a `null` value"));
        }
    }

    @Override
    protected void subscribing(UniSerializedSubscriber<? super T> subscriber) {
        if (this.challengers.isEmpty()) {
            subscriber.onSubscribe(EmptyUniSubscription.CANCELLED);
            subscriber.onItem(null);
            return;
        }
        if (this.challengers.size() == 1) {
            Uni<? super T> uni2 = this.challengers.get(0);
            AbstractUni.subscribe(uni2, subscriber);
            return;
        }
        AtomicBoolean completedOrCancelled = new AtomicBoolean();
        ArrayList futures = new ArrayList();
        this.challengers.forEach(uni -> {
            CompletableFuture future = uni.subscribe().asCompletionStage();
            futures.add(future);
        });
        subscriber.onSubscribe(() -> {
            if (completedOrCancelled.compareAndSet(false, true)) {
                futures.forEach(cf -> cf.cancel(false));
            }
        });
        futures.forEach(future -> future.whenComplete((res, fail) -> {
            if (completedOrCancelled.compareAndSet(false, true)) {
                futures.forEach(cf -> {
                    if (cf != future) {
                        cf.cancel(false);
                    }
                });
                if (fail != null) {
                    subscriber.onFailure((Throwable)fail);
                } else {
                    subscriber.onItem(res);
                }
            }
        }));
    }
}

