/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.ExecutionInput;
import graphql.GraphQLError;
import graphql.PublicApi;
import graphql.cachecontrol.CacheControl;
import graphql.execution.ExecutionContextBuilder;
import graphql.execution.ExecutionId;
import graphql.execution.ExecutionPath;
import graphql.execution.ExecutionStrategy;
import graphql.execution.ValueUnboxer;
import graphql.execution.defer.DeferSupport;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.language.Document;
import graphql.language.FragmentDefinition;
import graphql.language.OperationDefinition;
import graphql.schema.GraphQLSchema;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.dataloader.DataLoaderRegistry;

@PublicApi
public class ExecutionContext {
    private final GraphQLSchema graphQLSchema;
    private final ExecutionId executionId;
    private final InstrumentationState instrumentationState;
    private final ExecutionStrategy queryStrategy;
    private final ExecutionStrategy mutationStrategy;
    private final ExecutionStrategy subscriptionStrategy;
    private final Map<String, FragmentDefinition> fragmentsByName;
    private final OperationDefinition operationDefinition;
    private final Document document;
    private final Map<String, Object> variables;
    private final Object root;
    private final Object context;
    private final Object localContext;
    private final Instrumentation instrumentation;
    private final List<GraphQLError> errors = new CopyOnWriteArrayList<GraphQLError>();
    private final Set<ExecutionPath> errorPaths = new HashSet<ExecutionPath>();
    private final DataLoaderRegistry dataLoaderRegistry;
    private final CacheControl cacheControl;
    private final Locale locale;
    private final DeferSupport deferSupport = new DeferSupport();
    private final ValueUnboxer valueUnboxer;
    private final ExecutionInput executionInput;

    ExecutionContext(ExecutionContextBuilder builder) {
        this.graphQLSchema = builder.graphQLSchema;
        this.executionId = builder.executionId;
        this.instrumentationState = builder.instrumentationState;
        this.queryStrategy = builder.queryStrategy;
        this.mutationStrategy = builder.mutationStrategy;
        this.subscriptionStrategy = builder.subscriptionStrategy;
        this.fragmentsByName = Collections.unmodifiableMap(builder.fragmentsByName);
        this.variables = Collections.unmodifiableMap(builder.variables);
        this.document = builder.document;
        this.operationDefinition = builder.operationDefinition;
        this.context = builder.context;
        this.root = builder.root;
        this.instrumentation = builder.instrumentation;
        this.dataLoaderRegistry = builder.dataLoaderRegistry;
        this.cacheControl = builder.cacheControl;
        this.locale = builder.locale;
        this.valueUnboxer = builder.valueUnboxer;
        this.errors.addAll(builder.errors);
        this.localContext = builder.localContext;
        this.executionInput = builder.executionInput;
    }

    public ExecutionId getExecutionId() {
        return this.executionId;
    }

    public ExecutionInput getExecutionInput() {
        return this.executionInput;
    }

    public InstrumentationState getInstrumentationState() {
        return this.instrumentationState;
    }

    public Instrumentation getInstrumentation() {
        return this.instrumentation;
    }

    public GraphQLSchema getGraphQLSchema() {
        return this.graphQLSchema;
    }

    public Map<String, FragmentDefinition> getFragmentsByName() {
        return this.fragmentsByName;
    }

    public Document getDocument() {
        return this.document;
    }

    public OperationDefinition getOperationDefinition() {
        return this.operationDefinition;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public <T> T getContext() {
        return (T)this.context;
    }

    public <T> T getLocalContext() {
        return (T)this.localContext;
    }

    public <T> T getRoot() {
        return (T)this.root;
    }

    public FragmentDefinition getFragment(String name) {
        return this.fragmentsByName.get(name);
    }

    public DataLoaderRegistry getDataLoaderRegistry() {
        return this.dataLoaderRegistry;
    }

    public CacheControl getCacheControl() {
        return this.cacheControl;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ValueUnboxer getValueUnboxer() {
        return this.valueUnboxer;
    }

    public void addError(GraphQLError error, ExecutionPath fieldPath) {
        if (!this.errorPaths.add(fieldPath)) {
            return;
        }
        this.errors.add(error);
    }

    public void addError(GraphQLError error) {
        if (error.getPath() != null) {
            this.errorPaths.add(ExecutionPath.fromList(error.getPath()));
        }
        this.errors.add(error);
    }

    public List<GraphQLError> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public ExecutionStrategy getQueryStrategy() {
        return this.queryStrategy;
    }

    public ExecutionStrategy getMutationStrategy() {
        return this.mutationStrategy;
    }

    public ExecutionStrategy getSubscriptionStrategy() {
        return this.subscriptionStrategy;
    }

    public DeferSupport getDeferSupport() {
        return this.deferSupport;
    }

    public ExecutionContext transform(Consumer<ExecutionContextBuilder> builderConsumer) {
        ExecutionContextBuilder builder = ExecutionContextBuilder.newExecutionContextBuilder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }
}

