/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.AssertException;
import graphql.PublicApi;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;

@PublicApi
public class ExecutionPath {
    private static final ExecutionPath ROOT_PATH = new ExecutionPath();
    private final ExecutionPath parent;
    private final Object segment;
    private int hash;

    public static ExecutionPath rootPath() {
        return ROOT_PATH;
    }

    private ExecutionPath() {
        this.parent = null;
        this.segment = null;
    }

    private ExecutionPath(ExecutionPath parent, String segment) {
        this.parent = Assert.assertNotNull(parent, () -> "Must provide a parent path");
        this.segment = Assert.assertNotNull(segment, () -> "Must provide a sub path");
    }

    private ExecutionPath(ExecutionPath parent, int segment) {
        this.parent = Assert.assertNotNull(parent, () -> "Must provide a parent path");
        this.segment = segment;
    }

    public int getLevel() {
        int counter = 0;
        ExecutionPath currentPath = this;
        while (currentPath != null) {
            if (currentPath.segment instanceof String) {
                ++counter;
            }
            currentPath = currentPath.parent;
        }
        return counter;
    }

    public ExecutionPath getPathWithoutListEnd() {
        if (ROOT_PATH.equals(this)) {
            return ROOT_PATH;
        }
        if (this.segment instanceof String) {
            return this;
        }
        return this.parent;
    }

    public boolean isListSegment() {
        return this.segment instanceof Integer;
    }

    public boolean isNamedSegment() {
        return this.segment instanceof String;
    }

    public String getSegmentName() {
        return (String)this.segment;
    }

    public int getSegmentIndex() {
        return (Integer)this.segment;
    }

    public Object getSegmentValue() {
        return this.segment;
    }

    public ExecutionPath getParent() {
        return this.parent;
    }

    public static ExecutionPath parse(String pathString) {
        pathString = pathString == null ? "" : pathString;
        String finalPathString = pathString.trim();
        StringTokenizer st = new StringTokenizer(finalPathString, "/[]", true);
        ExecutionPath path = ExecutionPath.rootPath();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if ("/".equals(token)) {
                Assert.assertTrue(st.hasMoreTokens(), () -> String.format(ExecutionPath.mkErrMsg(), finalPathString));
                path = path.segment(st.nextToken());
                continue;
            }
            if ("[".equals(token)) {
                Assert.assertTrue(st.countTokens() >= 2, () -> String.format(ExecutionPath.mkErrMsg(), finalPathString));
                path = path.segment(Integer.parseInt(st.nextToken()));
                String closingBrace = st.nextToken();
                Assert.assertTrue(closingBrace.equals("]"), () -> String.format(ExecutionPath.mkErrMsg(), finalPathString));
                continue;
            }
            throw new AssertException(String.format(ExecutionPath.mkErrMsg(), pathString));
        }
        return path;
    }

    public static ExecutionPath fromList(List<?> objects) {
        Assert.assertNotNull(objects);
        ExecutionPath path = ExecutionPath.rootPath();
        for (Object object : objects) {
            if (object instanceof String) {
                path = path.segment((String)object);
                continue;
            }
            path = path.segment((Integer)object);
        }
        return path;
    }

    private static String mkErrMsg() {
        return "Invalid path string : '%s'";
    }

    public ExecutionPath segment(String segment) {
        return new ExecutionPath(this, segment);
    }

    public ExecutionPath segment(int segment) {
        return new ExecutionPath(this, segment);
    }

    public ExecutionPath dropSegment() {
        if (this == ExecutionPath.rootPath()) {
            return null;
        }
        return this.parent;
    }

    public ExecutionPath replaceSegment(int segment) {
        Assert.assertTrue(!ROOT_PATH.equals(this), () -> "You MUST not call this with the root path");
        return new ExecutionPath(this.parent, segment);
    }

    public ExecutionPath replaceSegment(String segment) {
        Assert.assertTrue(!ROOT_PATH.equals(this), () -> "You MUST not call this with the root path");
        return new ExecutionPath(this.parent, segment);
    }

    public boolean isRootPath() {
        return this == ROOT_PATH;
    }

    public ExecutionPath append(ExecutionPath path) {
        List<Object> objects = this.toList();
        objects.addAll(Assert.assertNotNull(path).toList());
        return ExecutionPath.fromList(objects);
    }

    public ExecutionPath sibling(String siblingField) {
        Assert.assertTrue(!ROOT_PATH.equals(this), () -> "You MUST not call this with the root path");
        return new ExecutionPath(this.parent, siblingField);
    }

    public ExecutionPath sibling(int siblingField) {
        Assert.assertTrue(!ROOT_PATH.equals(this), () -> "You MUST not call this with the root path");
        return new ExecutionPath(this.parent, siblingField);
    }

    public List<Object> toList() {
        if (this.parent == null) {
            return new LinkedList<Object>();
        }
        LinkedList<Object> list = new LinkedList<Object>();
        ExecutionPath p = this;
        while (p.segment != null) {
            list.addFirst(p.segment);
            p = p.parent;
        }
        return list;
    }

    public String toString() {
        if (this.parent == null) {
            return "";
        }
        if (ROOT_PATH.equals(this.parent)) {
            return this.segmentToString();
        }
        return this.parent.toString() + this.segmentToString();
    }

    public String segmentToString() {
        if (this.segment instanceof String) {
            return "/" + this.segment;
        }
        return "[" + this.segment + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutionPath self = this;
        ExecutionPath that = (ExecutionPath)o;
        while (self.segment != null && that.segment != null) {
            if (!Objects.equals(self.segment, that.segment)) {
                return false;
            }
            self = self.parent;
            that = that.parent;
        }
        return self.isRootPath() && that.isRootPath();
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            h = 1;
            ExecutionPath self = this;
            while (self != null) {
                Object value = self.segment;
                h = 31 * h + (value == null ? 0 : value.hashCode());
                self = self.parent;
            }
            this.hash = h;
        }
        return h;
    }
}

