/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.AssertException;
import graphql.Internal;
import graphql.PublicApi;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputObjectTypeExtensionDefinition;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLInputFieldsContainer;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLNamedInputType;
import graphql.schema.GraphQLNullableType;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.schema.GraphqlTypeBuilder;
import graphql.schema.GraphqlTypeComparatorRegistry;
import graphql.schema.SchemaElementChildrenContainer;
import graphql.util.FpKit;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

@PublicApi
public class GraphQLInputObjectType
implements GraphQLNamedInputType,
GraphQLUnmodifiedType,
GraphQLNullableType,
GraphQLInputFieldsContainer,
GraphQLDirectiveContainer {
    private final String name;
    private final String description;
    private final Map<String, GraphQLInputObjectField> fieldMap = new LinkedHashMap<String, GraphQLInputObjectField>();
    private final InputObjectTypeDefinition definition;
    private final List<InputObjectTypeExtensionDefinition> extensionDefinitions;
    private final List<GraphQLDirective> directives;
    public static final String CHILD_FIELD_DEFINITIONS = "fieldDefinitions";
    public static final String CHILD_DIRECTIVES = "directives";

    @Internal
    @Deprecated
    public GraphQLInputObjectType(String name, String description, List<GraphQLInputObjectField> fields) {
        this(name, description, fields, Collections.emptyList(), null);
    }

    @Internal
    @Deprecated
    public GraphQLInputObjectType(String name, String description, List<GraphQLInputObjectField> fields, List<GraphQLDirective> directives, InputObjectTypeDefinition definition) {
        this(name, description, fields, directives, definition, Collections.emptyList());
    }

    public GraphQLInputObjectType(String name, String description, List<GraphQLInputObjectField> fields, List<GraphQLDirective> directives, InputObjectTypeDefinition definition, List<InputObjectTypeExtensionDefinition> extensionDefinitions) {
        Assert.assertValidName(name);
        Assert.assertNotNull(fields, () -> "fields can't be null");
        Assert.assertNotNull(directives, () -> "directives cannot be null");
        this.name = name;
        this.description = description;
        this.definition = definition;
        this.extensionDefinitions = Collections.unmodifiableList(new ArrayList<InputObjectTypeExtensionDefinition>(extensionDefinitions));
        this.directives = directives;
        this.buildMap(fields);
    }

    private void buildMap(List<GraphQLInputObjectField> fields) {
        for (GraphQLInputObjectField field : fields) {
            String name = field.getName();
            if (this.fieldMap.containsKey(name)) {
                throw new AssertException("field " + name + " redefined");
            }
            this.fieldMap.put(name, field);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public List<GraphQLInputObjectField> getFields() {
        return new ArrayList<GraphQLInputObjectField>(this.fieldMap.values());
    }

    public GraphQLInputObjectField getField(String name) {
        return this.fieldMap.get(name);
    }

    @Override
    public List<GraphQLDirective> getDirectives() {
        return new ArrayList<GraphQLDirective>(this.directives);
    }

    @Override
    public GraphQLInputObjectField getFieldDefinition(String name) {
        return this.fieldMap.get(name);
    }

    @Override
    public List<GraphQLInputObjectField> getFieldDefinitions() {
        return new ArrayList<GraphQLInputObjectField>(this.fieldMap.values());
    }

    @Override
    public InputObjectTypeDefinition getDefinition() {
        return this.definition;
    }

    public List<InputObjectTypeExtensionDefinition> getExtensionDefinitions() {
        return this.extensionDefinitions;
    }

    public GraphQLInputObjectType transform(Consumer<Builder> builderConsumer) {
        Builder builder = GraphQLInputObjectType.newInputObject(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    @Override
    public TraversalControl accept(TraverserContext<GraphQLSchemaElement> context, GraphQLTypeVisitor visitor) {
        return visitor.visitGraphQLInputObjectType(this, context);
    }

    @Override
    public List<GraphQLSchemaElement> getChildren() {
        ArrayList<GraphQLSchemaElement> children = new ArrayList<GraphQLSchemaElement>(this.fieldMap.values());
        children.addAll(this.directives);
        return children;
    }

    @Override
    public SchemaElementChildrenContainer getChildrenWithTypeReferences() {
        return SchemaElementChildrenContainer.newSchemaElementChildrenContainer().children(CHILD_FIELD_DEFINITIONS, this.fieldMap.values()).children(CHILD_DIRECTIVES, this.directives).build();
    }

    @Override
    public GraphQLInputObjectType withNewChildren(SchemaElementChildrenContainer newChildren) {
        return this.transform(builder -> builder.replaceDirectives(newChildren.getChildren(CHILD_DIRECTIVES)).replaceFields(newChildren.getChildren(CHILD_FIELD_DEFINITIONS)));
    }

    public String toString() {
        return "GraphQLInputObjectType{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", fieldMap=" + this.fieldMap + ", definition=" + this.definition + ", directives=" + this.directives + '}';
    }

    public static Builder newInputObject(GraphQLInputObjectType existing) {
        return new Builder(existing);
    }

    public static Builder newInputObject() {
        return new Builder();
    }

    @PublicApi
    public static class Builder
    extends GraphqlTypeBuilder {
        private InputObjectTypeDefinition definition;
        private List<InputObjectTypeExtensionDefinition> extensionDefinitions = Collections.emptyList();
        private final Map<String, GraphQLInputObjectField> fields = new LinkedHashMap<String, GraphQLInputObjectField>();
        private final Map<String, GraphQLDirective> directives = new LinkedHashMap<String, GraphQLDirective>();

        public Builder() {
        }

        public Builder(GraphQLInputObjectType existing) {
            this.name = existing.getName();
            this.description = existing.getDescription();
            this.definition = existing.getDefinition();
            this.extensionDefinitions = existing.getExtensionDefinitions();
            this.fields.putAll(FpKit.getByName(existing.getFields(), GraphQLInputObjectField::getName));
            this.directives.putAll(FpKit.getByName(existing.getDirectives(), GraphQLDirective::getName));
        }

        @Override
        public Builder name(String name) {
            super.name(name);
            return this;
        }

        @Override
        public Builder description(String description) {
            super.description(description);
            return this;
        }

        @Override
        public Builder comparatorRegistry(GraphqlTypeComparatorRegistry comparatorRegistry) {
            super.comparatorRegistry(comparatorRegistry);
            return this;
        }

        public Builder definition(InputObjectTypeDefinition definition) {
            this.definition = definition;
            return this;
        }

        public Builder extensionDefinitions(List<InputObjectTypeExtensionDefinition> extensionDefinitions) {
            this.extensionDefinitions = extensionDefinitions;
            return this;
        }

        public Builder field(GraphQLInputObjectField field) {
            Assert.assertNotNull(field, () -> "field can't be null");
            this.fields.put(field.getName(), field);
            return this;
        }

        public Builder field(UnaryOperator<GraphQLInputObjectField.Builder> builderFunction) {
            Assert.assertNotNull(builderFunction, () -> "builderFunction should not be null");
            GraphQLInputObjectField.Builder builder = GraphQLInputObjectField.newInputObjectField();
            builder = (GraphQLInputObjectField.Builder)builderFunction.apply(builder);
            return this.field(builder);
        }

        public Builder field(GraphQLInputObjectField.Builder builder) {
            return this.field(builder.build());
        }

        public Builder fields(List<GraphQLInputObjectField> fields) {
            fields.forEach(this::field);
            return this;
        }

        public Builder replaceFields(List<GraphQLInputObjectField> fields) {
            this.fields.clear();
            fields.forEach(this::field);
            return this;
        }

        public boolean hasField(String fieldName) {
            return this.fields.containsKey(fieldName);
        }

        public Builder clearFields() {
            this.fields.clear();
            return this;
        }

        public Builder withDirectives(GraphQLDirective ... directives) {
            for (GraphQLDirective directive : directives) {
                this.withDirective(directive);
            }
            return this;
        }

        public Builder withDirective(GraphQLDirective directive) {
            Assert.assertNotNull(directive, () -> "directive can't be null");
            this.directives.put(directive.getName(), directive);
            return this;
        }

        public Builder replaceDirectives(List<GraphQLDirective> directives) {
            Assert.assertNotNull(directives, () -> "directive can't be null");
            this.directives.clear();
            for (GraphQLDirective directive : directives) {
                this.directives.put(directive.getName(), directive);
            }
            return this;
        }

        public Builder withDirective(GraphQLDirective.Builder builder) {
            return this.withDirective(builder.build());
        }

        public Builder clearDirectives() {
            this.directives.clear();
            return this;
        }

        public GraphQLInputObjectType build() {
            return new GraphQLInputObjectType(this.name, this.description, this.sort(this.fields, GraphQLInputObjectType.class, GraphQLInputObjectField.class), this.sort(this.directives, GraphQLInputObjectType.class, GraphQLDirective.class), this.definition, this.extensionDefinitions);
        }
    }
}

