/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.AssertException;
import graphql.Internal;
import graphql.PublicApi;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.InterfaceTypeExtensionDefinition;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLImplementingType;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLNullableType;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.schema.GraphqlTypeBuilder;
import graphql.schema.GraphqlTypeComparatorRegistry;
import graphql.schema.GraphqlTypeComparators;
import graphql.schema.SchemaElementChildrenContainer;
import graphql.schema.TypeResolver;
import graphql.util.FpKit;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

@PublicApi
public class GraphQLInterfaceType
implements GraphQLNamedType,
GraphQLCompositeType,
GraphQLUnmodifiedType,
GraphQLNullableType,
GraphQLDirectiveContainer,
GraphQLImplementingType {
    private final String name;
    private final String description;
    private final Map<String, GraphQLFieldDefinition> fieldDefinitionsByName = new LinkedHashMap<String, GraphQLFieldDefinition>();
    private final TypeResolver typeResolver;
    private final InterfaceTypeDefinition definition;
    private final List<InterfaceTypeExtensionDefinition> extensionDefinitions;
    private final List<GraphQLDirective> directives;
    private final List<GraphQLNamedOutputType> originalInterfaces;
    private final Comparator<? super GraphQLSchemaElement> interfaceComparator;
    private List<GraphQLNamedOutputType> replacedInterfaces;
    public static final String CHILD_FIELD_DEFINITIONS = "fieldDefinitions";
    public static final String CHILD_DIRECTIVES = "directives";
    public static final String CHILD_INTERFACES = "interfaces";

    @Internal
    @Deprecated
    public GraphQLInterfaceType(String name, String description, List<GraphQLFieldDefinition> fieldDefinitions, TypeResolver typeResolver) {
        this(name, description, fieldDefinitions, typeResolver, Collections.emptyList(), null);
    }

    @Internal
    @Deprecated
    public GraphQLInterfaceType(String name, String description, List<GraphQLFieldDefinition> fieldDefinitions, TypeResolver typeResolver, List<GraphQLDirective> directives, InterfaceTypeDefinition definition) {
        this(name, description, fieldDefinitions, typeResolver, directives, definition, Collections.emptyList(), Collections.emptyList(), GraphqlTypeComparators.asIsOrder());
    }

    @Internal
    @Deprecated
    public GraphQLInterfaceType(String name, String description, List<GraphQLFieldDefinition> fieldDefinitions, TypeResolver typeResolver, List<GraphQLDirective> directives, InterfaceTypeDefinition definition, List<InterfaceTypeExtensionDefinition> extensionDefinitions, List<GraphQLNamedOutputType> interfaces, Comparator<? super GraphQLSchemaElement> interfaceComparator) {
        Assert.assertValidName(name);
        Assert.assertNotNull(fieldDefinitions, () -> "fieldDefinitions can't null");
        Assert.assertNotNull(directives, () -> "directives cannot be null");
        this.name = name;
        this.description = description;
        this.typeResolver = typeResolver;
        this.definition = definition;
        this.interfaceComparator = interfaceComparator;
        this.originalInterfaces = GraphqlTypeComparators.sortTypes(interfaceComparator, interfaces);
        this.extensionDefinitions = Collections.unmodifiableList(new ArrayList<InterfaceTypeExtensionDefinition>(extensionDefinitions));
        this.directives = directives;
        this.buildDefinitionMap(fieldDefinitions);
    }

    private void buildDefinitionMap(List<GraphQLFieldDefinition> fieldDefinitions) {
        for (GraphQLFieldDefinition fieldDefinition : fieldDefinitions) {
            String name = fieldDefinition.getName();
            if (this.fieldDefinitionsByName.containsKey(name)) {
                throw new AssertException(String.format("Duplicated definition for field '%s' in interface '%s'", name, this.name));
            }
            this.fieldDefinitionsByName.put(name, fieldDefinition);
        }
    }

    @Override
    public GraphQLFieldDefinition getFieldDefinition(String name) {
        return this.fieldDefinitionsByName.get(name);
    }

    @Override
    public List<GraphQLFieldDefinition> getFieldDefinitions() {
        return new ArrayList<GraphQLFieldDefinition>(this.fieldDefinitionsByName.values());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    @Override
    public InterfaceTypeDefinition getDefinition() {
        return this.definition;
    }

    public List<InterfaceTypeExtensionDefinition> getExtensionDefinitions() {
        return this.extensionDefinitions;
    }

    @Override
    public List<GraphQLDirective> getDirectives() {
        return new ArrayList<GraphQLDirective>(this.directives);
    }

    public String toString() {
        return "GraphQLInterfaceType{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", fieldDefinitionsByName=" + this.fieldDefinitionsByName.keySet() + ", typeResolver=" + this.typeResolver + '}';
    }

    public GraphQLInterfaceType transform(Consumer<Builder> builderConsumer) {
        Builder builder = GraphQLInterfaceType.newInterface(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    @Override
    public TraversalControl accept(TraverserContext<GraphQLSchemaElement> context, GraphQLTypeVisitor visitor) {
        return visitor.visitGraphQLInterfaceType(this, context);
    }

    @Override
    public List<GraphQLSchemaElement> getChildren() {
        ArrayList<GraphQLSchemaElement> children = new ArrayList<GraphQLSchemaElement>(this.fieldDefinitionsByName.values());
        children.addAll(this.directives);
        children.addAll(this.getInterfaces());
        return children;
    }

    @Override
    public SchemaElementChildrenContainer getChildrenWithTypeReferences() {
        return SchemaElementChildrenContainer.newSchemaElementChildrenContainer().children(CHILD_FIELD_DEFINITIONS, this.fieldDefinitionsByName.values()).children(CHILD_DIRECTIVES, this.directives).children(CHILD_INTERFACES, this.originalInterfaces).build();
    }

    @Override
    public GraphQLInterfaceType withNewChildren(SchemaElementChildrenContainer newChildren) {
        return this.transform(builder -> builder.replaceDirectives(newChildren.getChildren(CHILD_DIRECTIVES)).replaceFields(newChildren.getChildren(CHILD_FIELD_DEFINITIONS)).replaceInterfaces(newChildren.getChildren(CHILD_INTERFACES)));
    }

    @Override
    public List<GraphQLNamedOutputType> getInterfaces() {
        if (this.replacedInterfaces != null) {
            return Collections.unmodifiableList(this.replacedInterfaces);
        }
        return Collections.unmodifiableList(this.originalInterfaces);
    }

    void replaceInterfaces(List<GraphQLNamedOutputType> interfaces) {
        this.replacedInterfaces = GraphqlTypeComparators.sortTypes(this.interfaceComparator, interfaces);
    }

    public static Builder newInterface() {
        return new Builder();
    }

    public static Builder newInterface(GraphQLInterfaceType existing) {
        return new Builder(existing);
    }

    @PublicApi
    public static class Builder
    extends GraphqlTypeBuilder {
        private TypeResolver typeResolver;
        private InterfaceTypeDefinition definition;
        private List<InterfaceTypeExtensionDefinition> extensionDefinitions = Collections.emptyList();
        private final Map<String, GraphQLFieldDefinition> fields = new LinkedHashMap<String, GraphQLFieldDefinition>();
        private final Map<String, GraphQLDirective> directives = new LinkedHashMap<String, GraphQLDirective>();
        private final Map<String, GraphQLNamedOutputType> interfaces = new LinkedHashMap<String, GraphQLNamedOutputType>();

        public Builder() {
        }

        public Builder(GraphQLInterfaceType existing) {
            this.name = existing.getName();
            this.description = existing.getDescription();
            this.typeResolver = existing.getTypeResolver();
            this.definition = existing.getDefinition();
            this.extensionDefinitions = existing.getExtensionDefinitions();
            this.fields.putAll(FpKit.getByName(existing.getFieldDefinitions(), GraphQLFieldDefinition::getName));
            this.directives.putAll(FpKit.getByName(existing.getDirectives(), GraphQLDirective::getName));
            this.interfaces.putAll(FpKit.getByName(existing.originalInterfaces, GraphQLNamedSchemaElement::getName));
        }

        @Override
        public Builder name(String name) {
            super.name(name);
            return this;
        }

        @Override
        public Builder description(String description) {
            super.description(description);
            return this;
        }

        @Override
        public Builder comparatorRegistry(GraphqlTypeComparatorRegistry comparatorRegistry) {
            super.comparatorRegistry(comparatorRegistry);
            return this;
        }

        public Builder definition(InterfaceTypeDefinition definition) {
            this.definition = definition;
            return this;
        }

        public Builder extensionDefinitions(List<InterfaceTypeExtensionDefinition> extensionDefinitions) {
            this.extensionDefinitions = extensionDefinitions;
            return this;
        }

        public Builder field(GraphQLFieldDefinition fieldDefinition) {
            Assert.assertNotNull(fieldDefinition, () -> "fieldDefinition can't be null");
            this.fields.put(fieldDefinition.getName(), fieldDefinition);
            return this;
        }

        public Builder field(UnaryOperator<GraphQLFieldDefinition.Builder> builderFunction) {
            Assert.assertNotNull(builderFunction, () -> "builderFunction can't be null");
            GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition();
            builder = (GraphQLFieldDefinition.Builder)builderFunction.apply(builder);
            return this.field(builder);
        }

        public Builder field(GraphQLFieldDefinition.Builder builder) {
            return this.field(builder.build());
        }

        public Builder fields(List<GraphQLFieldDefinition> fieldDefinitions) {
            Assert.assertNotNull(fieldDefinitions, () -> "fieldDefinitions can't be null");
            fieldDefinitions.forEach(this::field);
            return this;
        }

        public Builder replaceFields(List<GraphQLFieldDefinition> fieldDefinitions) {
            Assert.assertNotNull(fieldDefinitions, () -> "fieldDefinitions can't be null");
            this.fields.clear();
            fieldDefinitions.forEach(this::field);
            return this;
        }

        public boolean hasField(String fieldName) {
            return this.fields.containsKey(fieldName);
        }

        public Builder clearFields() {
            this.fields.clear();
            return this;
        }

        @Deprecated
        public Builder typeResolver(TypeResolver typeResolver) {
            this.typeResolver = typeResolver;
            return this;
        }

        public Builder withDirectives(GraphQLDirective ... directives) {
            for (GraphQLDirective directive : directives) {
                this.withDirective(directive);
            }
            return this;
        }

        public Builder withDirective(GraphQLDirective directive) {
            Assert.assertNotNull(directive, () -> "directive can't be null");
            this.directives.put(directive.getName(), directive);
            return this;
        }

        public Builder replaceDirectives(List<GraphQLDirective> directives) {
            Assert.assertNotNull(directives, () -> "directive can't be null");
            this.directives.clear();
            for (GraphQLDirective directive : directives) {
                this.directives.put(directive.getName(), directive);
            }
            return this;
        }

        public Builder withDirective(GraphQLDirective.Builder builder) {
            return this.withDirective(builder.build());
        }

        public Builder clearDirectives() {
            this.directives.clear();
            return this;
        }

        public Builder withInterface(GraphQLInterfaceType interfaceType) {
            Assert.assertNotNull(interfaceType, () -> "interfaceType can't be null");
            this.interfaces.put(interfaceType.getName(), interfaceType);
            return this;
        }

        public Builder replaceInterfaces(List<GraphQLInterfaceType> interfaces) {
            Assert.assertNotNull(interfaces, () -> "interfaces can't be null");
            this.interfaces.clear();
            for (GraphQLInterfaceType interfaceType : interfaces) {
                this.interfaces.put(interfaceType.getName(), interfaceType);
            }
            return this;
        }

        public Builder withInterface(GraphQLTypeReference reference) {
            Assert.assertNotNull(reference, () -> "reference can't be null");
            this.interfaces.put(reference.getName(), reference);
            return this;
        }

        public Builder withInterfaces(GraphQLInterfaceType ... interfaceType) {
            for (GraphQLInterfaceType type : interfaceType) {
                this.withInterface(type);
            }
            return this;
        }

        public GraphQLInterfaceType build() {
            return new GraphQLInterfaceType(this.name, this.description, this.sort(this.fields, GraphQLInterfaceType.class, GraphQLFieldDefinition.class), this.typeResolver, this.sort(this.directives, GraphQLInterfaceType.class, GraphQLDirective.class), this.definition, this.extensionDefinitions, FpKit.valuesToList(this.interfaces), this.getComparator(GraphQLInterfaceType.class, GraphQLInterfaceType.class));
        }
    }
}

