/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.Internal;
import graphql.PublicApi;
import graphql.language.UnionTypeDefinition;
import graphql.language.UnionTypeExtensionDefinition;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLNullableType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.schema.GraphqlTypeBuilder;
import graphql.schema.GraphqlTypeComparatorRegistry;
import graphql.schema.SchemaElementChildrenContainer;
import graphql.schema.TypeResolver;
import graphql.util.FpKit;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

@PublicApi
public class GraphQLUnionType
implements GraphQLNamedOutputType,
GraphQLCompositeType,
GraphQLUnmodifiedType,
GraphQLNullableType,
GraphQLDirectiveContainer {
    private final String name;
    private final String description;
    private final List<GraphQLNamedOutputType> originalTypes;
    private final TypeResolver typeResolver;
    private final UnionTypeDefinition definition;
    private final List<UnionTypeExtensionDefinition> extensionDefinitions;
    private final List<GraphQLDirective> directives;
    private List<GraphQLNamedOutputType> replacedTypes;
    public static final String CHILD_TYPES = "types";
    public static final String CHILD_DIRECTIVES = "directives";

    @Internal
    @Deprecated
    public GraphQLUnionType(String name, String description, List<GraphQLNamedOutputType> types, TypeResolver typeResolver) {
        this(name, description, types, typeResolver, Collections.emptyList(), null);
    }

    @Internal
    @Deprecated
    public GraphQLUnionType(String name, String description, List<GraphQLNamedOutputType> types, TypeResolver typeResolver, List<GraphQLDirective> directives, UnionTypeDefinition definition) {
        this(name, description, types, typeResolver, directives, definition, Collections.emptyList());
    }

    private GraphQLUnionType(String name, String description, List<GraphQLNamedOutputType> types, TypeResolver typeResolver, List<GraphQLDirective> directives, UnionTypeDefinition definition, List<UnionTypeExtensionDefinition> extensionDefinitions) {
        Assert.assertValidName(name);
        Assert.assertNotNull(types, () -> "types can't be null");
        Assert.assertNotEmpty(types, () -> "A Union type must define one or more member types.");
        Assert.assertNotNull(directives, () -> "directives cannot be null");
        this.name = name;
        this.description = description;
        this.originalTypes = types;
        this.typeResolver = typeResolver;
        this.definition = definition;
        this.extensionDefinitions = Collections.unmodifiableList(new ArrayList<UnionTypeExtensionDefinition>(extensionDefinitions));
        this.directives = directives;
    }

    void replaceTypes(List<GraphQLNamedOutputType> types) {
        this.replacedTypes = types;
    }

    public List<GraphQLNamedOutputType> getTypes() {
        if (this.replacedTypes != null) {
            return Collections.unmodifiableList(this.replacedTypes);
        }
        return Collections.unmodifiableList(this.originalTypes);
    }

    TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public UnionTypeDefinition getDefinition() {
        return this.definition;
    }

    public List<UnionTypeExtensionDefinition> getExtensionDefinitions() {
        return this.extensionDefinitions;
    }

    @Override
    public List<GraphQLDirective> getDirectives() {
        return new ArrayList<GraphQLDirective>(this.directives);
    }

    public GraphQLUnionType transform(Consumer<Builder> builderConsumer) {
        Builder builder = GraphQLUnionType.newUnionType(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    @Override
    public TraversalControl accept(TraverserContext<GraphQLSchemaElement> context, GraphQLTypeVisitor visitor) {
        return visitor.visitGraphQLUnionType(this, context);
    }

    @Override
    public List<GraphQLSchemaElement> getChildren() {
        ArrayList<GraphQLSchemaElement> children = new ArrayList<GraphQLSchemaElement>(this.getTypes());
        children.addAll(this.directives);
        return children;
    }

    @Override
    public SchemaElementChildrenContainer getChildrenWithTypeReferences() {
        return SchemaElementChildrenContainer.newSchemaElementChildrenContainer().children(CHILD_TYPES, this.originalTypes).children(CHILD_DIRECTIVES, this.directives).build();
    }

    @Override
    public GraphQLUnionType withNewChildren(SchemaElementChildrenContainer newChildren) {
        return this.transform(builder -> builder.replaceDirectives(newChildren.getChildren(CHILD_DIRECTIVES)).replacePossibleTypes(newChildren.getChildren(CHILD_TYPES)));
    }

    public static Builder newUnionType() {
        return new Builder();
    }

    public static Builder newUnionType(GraphQLUnionType existing) {
        return new Builder(existing);
    }

    @PublicApi
    public static class Builder
    extends GraphqlTypeBuilder {
        private TypeResolver typeResolver;
        private UnionTypeDefinition definition;
        private List<UnionTypeExtensionDefinition> extensionDefinitions = Collections.emptyList();
        private final Map<String, GraphQLNamedOutputType> types = new LinkedHashMap<String, GraphQLNamedOutputType>();
        private final Map<String, GraphQLDirective> directives = new LinkedHashMap<String, GraphQLDirective>();

        public Builder() {
        }

        public Builder(GraphQLUnionType existing) {
            this.name = existing.getName();
            this.description = existing.getDescription();
            this.typeResolver = existing.getTypeResolver();
            this.definition = existing.getDefinition();
            this.extensionDefinitions = existing.getExtensionDefinitions();
            this.types.putAll(FpKit.getByName(existing.originalTypes, GraphQLNamedSchemaElement::getName));
            this.directives.putAll(FpKit.getByName(existing.getDirectives(), GraphQLDirective::getName));
        }

        @Override
        public Builder name(String name) {
            super.name(name);
            return this;
        }

        @Override
        public Builder description(String description) {
            super.description(description);
            return this;
        }

        @Override
        public Builder comparatorRegistry(GraphqlTypeComparatorRegistry comparatorRegistry) {
            super.comparatorRegistry(comparatorRegistry);
            return this;
        }

        public Builder definition(UnionTypeDefinition definition) {
            this.definition = definition;
            return this;
        }

        public Builder extensionDefinitions(List<UnionTypeExtensionDefinition> extensionDefinitions) {
            this.extensionDefinitions = extensionDefinitions;
            return this;
        }

        @Deprecated
        public Builder typeResolver(TypeResolver typeResolver) {
            this.typeResolver = typeResolver;
            return this;
        }

        public Builder possibleType(GraphQLObjectType type) {
            Assert.assertNotNull(type, () -> "possible type can't be null");
            this.types.put(type.getName(), type);
            return this;
        }

        public Builder possibleType(GraphQLTypeReference reference) {
            Assert.assertNotNull(reference, () -> "reference can't be null");
            this.types.put(reference.getName(), reference);
            return this;
        }

        public Builder possibleTypes(GraphQLObjectType ... type) {
            for (GraphQLObjectType graphQLType : type) {
                this.possibleType(graphQLType);
            }
            return this;
        }

        public Builder replacePossibleTypes(List<GraphQLObjectType> types) {
            this.types.clear();
            for (GraphQLObjectType graphQLType : types) {
                this.possibleType(graphQLType);
            }
            return this;
        }

        public Builder possibleTypes(GraphQLTypeReference ... references) {
            for (GraphQLTypeReference reference : references) {
                this.possibleType(reference);
            }
            return this;
        }

        public Builder clearPossibleTypes() {
            this.types.clear();
            return this;
        }

        public boolean containType(String name) {
            return this.types.containsKey(name);
        }

        public Builder withDirectives(GraphQLDirective ... directives) {
            for (GraphQLDirective directive : directives) {
                this.withDirective(directive);
            }
            return this;
        }

        public Builder replaceDirectives(List<GraphQLDirective> directives) {
            Assert.assertNotNull(directives, () -> "directive can't be null");
            this.directives.clear();
            for (GraphQLDirective directive : directives) {
                this.directives.put(directive.getName(), directive);
            }
            return this;
        }

        public Builder withDirective(GraphQLDirective directive) {
            Assert.assertNotNull(directive, () -> "directive can't be null");
            this.directives.put(directive.getName(), directive);
            return this;
        }

        public Builder withDirective(GraphQLDirective.Builder builder) {
            return this.withDirective(builder.build());
        }

        public Builder clearDirectives() {
            this.directives.clear();
            return this;
        }

        public GraphQLUnionType build() {
            return new GraphQLUnionType(this.name, this.description, this.sort(this.types, GraphQLUnionType.class, GraphQLOutputType.class), this.typeResolver, this.sort(this.directives, GraphQLUnionType.class, GraphQLDirective.class), this.definition, this.extensionDefinitions);
        }
    }
}

