/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.GraphQLException;
import graphql.Internal;
import graphql.Scalars;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;

@Internal
public class PropertyDataFetcherHelper {
    private static final AtomicBoolean USE_SET_ACCESSIBLE = new AtomicBoolean(true);
    private static final AtomicBoolean USE_NEGATIVE_CACHE = new AtomicBoolean(true);
    private static final ConcurrentMap<String, Method> METHOD_CACHE = new ConcurrentHashMap<String, Method>();
    private static final ConcurrentMap<String, Field> FIELD_CACHE = new ConcurrentHashMap<String, Field>();
    private static final ConcurrentMap<String, String> NEGATIVE_CACHE = new ConcurrentHashMap<String, String>();

    public static Object getPropertyValue(String propertyName, Object object, GraphQLType graphQLType) {
        return PropertyDataFetcherHelper.getPropertyValue(propertyName, object, graphQLType, null);
    }

    public static Object getPropertyValue(String propertyName, Object object, GraphQLType graphQLType, DataFetchingEnvironment environment) {
        Field cachedField;
        if (object instanceof Map) {
            return ((Map)object).get(propertyName);
        }
        String key = PropertyDataFetcherHelper.mkKey(object, propertyName);
        if (PropertyDataFetcherHelper.isNegativelyCached(key)) {
            return null;
        }
        Method cachedMethod = (Method)METHOD_CACHE.get(key);
        if (cachedMethod != null) {
            MethodFinder methodFinder = (aClass, methodName) -> cachedMethod;
            try {
                return PropertyDataFetcherHelper.getPropertyViaGetterMethod(object, propertyName, graphQLType, methodFinder, environment);
            }
            catch (NoSuchMethodException ignored) {
                Assert.assertShouldNeverHappen("A method cached as '%s' is no longer available??", key);
            }
        }
        if ((cachedField = (Field)FIELD_CACHE.get(key)) != null) {
            try {
                return PropertyDataFetcherHelper.getPropertyViaFieldAccess(object, propertyName);
            }
            catch (FastNoSuchMethodException ignored) {
                Assert.assertShouldNeverHappen("A field cached as '%s' is no longer available??", key);
            }
        }
        boolean dfeInUse = environment != null;
        try {
            MethodFinder methodFinder = (root, methodName) -> PropertyDataFetcherHelper.findPubliclyAccessibleMethod(propertyName, root, methodName, dfeInUse);
            return PropertyDataFetcherHelper.getPropertyViaGetterMethod(object, propertyName, graphQLType, methodFinder, environment);
        }
        catch (NoSuchMethodException ignored) {
            try {
                MethodFinder methodFinder = (aClass, methodName) -> PropertyDataFetcherHelper.findViaSetAccessible(propertyName, aClass, methodName, dfeInUse);
                return PropertyDataFetcherHelper.getPropertyViaGetterMethod(object, propertyName, graphQLType, methodFinder, environment);
            }
            catch (NoSuchMethodException ignored2) {
                try {
                    return PropertyDataFetcherHelper.getPropertyViaFieldAccess(object, propertyName);
                }
                catch (FastNoSuchMethodException e) {
                    PropertyDataFetcherHelper.putInNegativeCache(key);
                    return null;
                }
            }
        }
    }

    private static boolean isNegativelyCached(String key) {
        if (USE_NEGATIVE_CACHE.get()) {
            return NEGATIVE_CACHE.containsKey(key);
        }
        return false;
    }

    private static void putInNegativeCache(String key) {
        if (USE_NEGATIVE_CACHE.get()) {
            NEGATIVE_CACHE.put(key, key);
        }
    }

    private static Object getPropertyViaGetterMethod(Object object, String propertyName, GraphQLType graphQLType, MethodFinder methodFinder, DataFetchingEnvironment environment) throws NoSuchMethodException {
        if (PropertyDataFetcherHelper.isBooleanProperty(graphQLType)) {
            try {
                return PropertyDataFetcherHelper.getPropertyViaGetterUsingPrefix(object, propertyName, "is", methodFinder, environment);
            }
            catch (NoSuchMethodException e) {
                return PropertyDataFetcherHelper.getPropertyViaGetterUsingPrefix(object, propertyName, "get", methodFinder, environment);
            }
        }
        return PropertyDataFetcherHelper.getPropertyViaGetterUsingPrefix(object, propertyName, "get", methodFinder, environment);
    }

    private static Object getPropertyViaGetterUsingPrefix(Object object, String propertyName, String prefix, MethodFinder methodFinder, DataFetchingEnvironment environment) throws NoSuchMethodException {
        String getterName = prefix + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        try {
            Method method = methodFinder.apply(object.getClass(), getterName);
            if (PropertyDataFetcherHelper.takesDataFetcherEnvironmentAsOnlyArgument(method)) {
                if (environment == null) {
                    throw new FastNoSuchMethodException(getterName);
                }
                return method.invoke(object, environment);
            }
            return method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new GraphQLException(e);
        }
    }

    private static Method findPubliclyAccessibleMethod(String propertyName, Class<?> root, String methodName, boolean dfeInUse) throws NoSuchMethodException {
        for (Class<?> currentClass = root; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Method method;
            String key = PropertyDataFetcherHelper.mkKey(currentClass, propertyName);
            if (!Modifier.isPublic(currentClass.getModifiers())) continue;
            if (dfeInUse) {
                try {
                    method = currentClass.getMethod(methodName, DataFetchingEnvironment.class);
                    if (Modifier.isPublic(method.getModifiers())) {
                        METHOD_CACHE.putIfAbsent(key, method);
                        return method;
                    }
                }
                catch (NoSuchMethodException method2) {
                    // empty catch block
                }
            }
            if (!Modifier.isPublic((method = currentClass.getMethod(methodName, new Class[0])).getModifiers())) continue;
            METHOD_CACHE.putIfAbsent(key, method);
            return method;
        }
        return root.getMethod(methodName, new Class[0]);
    }

    private static Method findViaSetAccessible(String propertyName, Class<?> aClass, String methodName, boolean dfeInUse) throws NoSuchMethodException {
        if (!USE_SET_ACCESSIBLE.get()) {
            throw new FastNoSuchMethodException(methodName);
        }
        for (Class<?> currentClass = aClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            String key = PropertyDataFetcherHelper.mkKey(currentClass, propertyName);
            Predicate<Method> whichMethods = mth -> {
                if (dfeInUse) {
                    return PropertyDataFetcherHelper.hasZeroArgs(mth) || PropertyDataFetcherHelper.takesDataFetcherEnvironmentAsOnlyArgument(mth);
                }
                return PropertyDataFetcherHelper.hasZeroArgs(mth);
            };
            Method[] declaredMethods = currentClass.getDeclaredMethods();
            Optional<? super Method> m = Arrays.stream(declaredMethods).filter(mth -> methodName.equals(mth.getName())).filter(whichMethods).min(PropertyDataFetcherHelper.mostMethodArgsFirst());
            if (!m.isPresent()) continue;
            try {
                Method method = m.get();
                method.setAccessible(true);
                METHOD_CACHE.putIfAbsent(key, method);
                return method;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        throw new FastNoSuchMethodException(methodName);
    }

    private static Object getPropertyViaFieldAccess(Object object, String propertyName) throws FastNoSuchMethodException {
        Class<?> aClass = object.getClass();
        String key = PropertyDataFetcherHelper.mkKey(aClass, propertyName);
        try {
            Field field = aClass.getField(propertyName);
            FIELD_CACHE.putIfAbsent(key, field);
            return field.get(object);
        }
        catch (NoSuchFieldException e) {
            if (!USE_SET_ACCESSIBLE.get()) {
                throw new FastNoSuchMethodException(key);
            }
            try {
                Field field = aClass.getDeclaredField(propertyName);
                field.setAccessible(true);
                FIELD_CACHE.putIfAbsent(key, field);
                return field.get(object);
            }
            catch (NoSuchFieldException | SecurityException ignored2) {
                throw new FastNoSuchMethodException(key);
            }
            catch (IllegalAccessException e1) {
                throw new GraphQLException(e);
            }
        }
        catch (IllegalAccessException e) {
            throw new GraphQLException(e);
        }
    }

    private static boolean isBooleanProperty(GraphQLType graphQLType) {
        if (graphQLType == Scalars.GraphQLBoolean) {
            return true;
        }
        if (GraphQLTypeUtil.isNonNull(graphQLType)) {
            return GraphQLTypeUtil.unwrapOne(graphQLType) == Scalars.GraphQLBoolean;
        }
        return false;
    }

    public static void clearReflectionCache() {
        METHOD_CACHE.clear();
        FIELD_CACHE.clear();
        NEGATIVE_CACHE.clear();
    }

    public static boolean setUseSetAccessible(boolean flag) {
        return USE_SET_ACCESSIBLE.getAndSet(flag);
    }

    public static boolean setUseNegativeCache(boolean flag) {
        return USE_NEGATIVE_CACHE.getAndSet(flag);
    }

    private static String mkKey(Object object, String propertyName) {
        return PropertyDataFetcherHelper.mkKey(object.getClass(), propertyName);
    }

    private static String mkKey(Class<?> clazz, String propertyName) {
        return clazz.getName() + "__" + propertyName;
    }

    private static boolean hasZeroArgs(Method mth) {
        return mth.getParameterCount() == 0;
    }

    private static boolean takesDataFetcherEnvironmentAsOnlyArgument(Method mth) {
        return mth.getParameterCount() == 1 && mth.getParameterTypes()[0].equals(DataFetchingEnvironment.class);
    }

    private static Comparator<? super Method> mostMethodArgsFirst() {
        return Comparator.comparingInt(Method::getParameterCount).reversed();
    }

    private static class FastNoSuchMethodException
    extends NoSuchMethodException {
        public FastNoSuchMethodException(String methodName) {
            super(methodName);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    private static interface MethodFinder {
        public Method apply(Class<?> var1, String var2) throws NoSuchMethodException;
    }
}

