/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.PublicApi;
import graphql.introspection.Introspection;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLSchemaElementAdapter;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.SchemaElementChildrenContainer;
import graphql.util.Breadcrumb;
import graphql.util.FpKit;
import graphql.util.NodeAdapter;
import graphql.util.NodeLocation;
import graphql.util.NodeZipper;
import graphql.util.TraversalControl;
import graphql.util.Traverser;
import graphql.util.TraverserContext;
import graphql.util.TraverserVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@PublicApi
public class SchemaTransformer {
    public static GraphQLSchema transformSchema(GraphQLSchema schema, GraphQLTypeVisitor visitor) {
        SchemaTransformer schemaTransformer = new SchemaTransformer();
        return schemaTransformer.transform(schema, visitor);
    }

    public GraphQLSchema transform(GraphQLSchema schema, final GraphQLTypeVisitor visitor) {
        final DummyRoot dummyRoot = new DummyRoot(schema);
        final LinkedList<NodeZipper<GraphQLSchemaElement>> zippers = new LinkedList<NodeZipper<GraphQLSchemaElement>>();
        final LinkedHashMap<GraphQLSchemaElement, NodeZipper<GraphQLSchemaElement>> zipperByNodeAfterTraversing = new LinkedHashMap<GraphQLSchemaElement, NodeZipper<GraphQLSchemaElement>>();
        final LinkedHashMap zipperByOriginalNode = new LinkedHashMap();
        final LinkedHashMap<NodeZipper<GraphQLSchemaElement>, List<List<Breadcrumb<GraphQLSchemaElement>>>> breadcrumbsByZipper = new LinkedHashMap<NodeZipper<GraphQLSchemaElement>, List<List<Breadcrumb<GraphQLSchemaElement>>>>();
        TraverserVisitor<GraphQLSchemaElement> nodeTraverserVisitor = new TraverserVisitor<GraphQLSchemaElement>(){

            @Override
            public TraversalControl enter(TraverserContext<GraphQLSchemaElement> context) {
                if (context.thisNode() == dummyRoot) {
                    return TraversalControl.CONTINUE;
                }
                NodeZipper nodeZipper = new NodeZipper(context.thisNode(), context.getBreadcrumbs(), GraphQLSchemaElementAdapter.SCHEMA_ELEMENT_ADAPTER);
                context.setVar(NodeZipper.class, nodeZipper);
                context.setVar(NodeAdapter.class, GraphQLSchemaElementAdapter.SCHEMA_ELEMENT_ADAPTER);
                int zippersBefore = zippers.size();
                TraversalControl result = context.thisNode().accept(context, visitor);
                if (zippersBefore + 1 == zippers.size()) {
                    nodeZipper = (NodeZipper)zippers.get(zippers.size() - 1);
                }
                zipperByOriginalNode.put(context.originalThisNode(), nodeZipper);
                if (context.isDeleted()) {
                    zipperByNodeAfterTraversing.put(context.originalThisNode(), nodeZipper);
                } else {
                    zipperByNodeAfterTraversing.put(context.thisNode(), nodeZipper);
                }
                breadcrumbsByZipper.put(nodeZipper, new ArrayList());
                ((List)breadcrumbsByZipper.get(nodeZipper)).add(context.getBreadcrumbs());
                return result;
            }

            @Override
            public TraversalControl leave(TraverserContext<GraphQLSchemaElement> context) {
                return TraversalControl.CONTINUE;
            }

            @Override
            public TraversalControl backRef(TraverserContext<GraphQLSchemaElement> context) {
                NodeZipper zipper = (NodeZipper)zipperByOriginalNode.get(context.thisNode());
                ((List)breadcrumbsByZipper.get(zipper)).add(context.getBreadcrumbs());
                visitor.visitBackRef(context);
                return TraversalControl.CONTINUE;
            }
        };
        Traverser<GraphQLSchemaElement> traverser = Traverser.depthFirstWithNamedChildren(GraphQLSchemaElementAdapter.SCHEMA_ELEMENT_ADAPTER::getNamedChildren, zippers, null);
        GraphQLCodeRegistry.Builder builder = GraphQLCodeRegistry.newCodeRegistry(schema.getCodeRegistry());
        traverser.rootVar(GraphQLCodeRegistry.Builder.class, builder);
        traverser.traverse(dummyRoot, nodeTraverserVisitor);
        this.toRootNode(zippers, breadcrumbsByZipper, zipperByNodeAfterTraversing);
        GraphQLSchema newSchema = GraphQLSchema.newSchema().query(dummyRoot.query).mutation(dummyRoot.mutation).subscription(dummyRoot.subscription).additionalTypes(dummyRoot.additionalTypes).additionalDirectives(dummyRoot.directives).codeRegistry(builder.build()).buildImpl(true);
        return newSchema;
    }

    private void toRootNode(List<NodeZipper<GraphQLSchemaElement>> zippers, Map<NodeZipper<GraphQLSchemaElement>, List<List<Breadcrumb<GraphQLSchemaElement>>>> breadcrumbsByZipper, Map<GraphQLSchemaElement, NodeZipper<GraphQLSchemaElement>> zipperByNodeAfterTraversing) {
        if (zippers.size() == 0) {
            return;
        }
        LinkedHashSet<NodeZipper<GraphQLSchemaElement>> curZippers = new LinkedHashSet<NodeZipper<GraphQLSchemaElement>>(zippers);
        LinkedHashMap<NodeZipper<GraphQLSchemaElement>, List<List<Breadcrumb<GraphQLSchemaElement>>>> curBreadcrumbsByZipper = new LinkedHashMap<NodeZipper<GraphQLSchemaElement>, List<List<Breadcrumb<GraphQLSchemaElement>>>>(breadcrumbsByZipper);
        while (curZippers.size() > 1 || !(((NodeZipper)curZippers.iterator().next()).getCurNode() instanceof DummyRoot)) {
            ArrayList<NodeZipper<GraphQLSchemaElement>> deepestZippers = new ArrayList<NodeZipper<GraphQLSchemaElement>>();
            int depth = this.getDeepestZippers(curZippers, curBreadcrumbsByZipper, deepestZippers);
            Map<NodeZipper<GraphQLSchemaElement>, List<List<Breadcrumb<GraphQLSchemaElement>>>> breadcrumbsUsed = this.getBreadcrumbsUsed(curZippers, curBreadcrumbsByZipper, depth);
            Map<GraphQLSchemaElement, List<NodeZipper<GraphQLSchemaElement>>> zippersByParent = this.groupBySameParent(deepestZippers, breadcrumbsUsed);
            ArrayList<NodeZipper<GraphQLSchemaElement>> newZippers = new ArrayList<NodeZipper<GraphQLSchemaElement>>();
            for (Map.Entry<GraphQLSchemaElement, List<NodeZipper<GraphQLSchemaElement>>> entry : zippersByParent.entrySet()) {
                GraphQLSchemaElement parentNode = entry.getKey();
                NodeZipper<GraphQLSchemaElement> newZipper = this.moveUp(parentNode, entry.getValue(), breadcrumbsUsed);
                NodeZipper<GraphQLSchemaElement> originalZipperForParent = zipperByNodeAfterTraversing.get(parentNode);
                curZippers.remove(originalZipperForParent);
                List breadcrumbsForOriginalParent = (List)curBreadcrumbsByZipper.get(originalZipperForParent);
                curBreadcrumbsByZipper.remove(originalZipperForParent);
                curBreadcrumbsByZipper.put(newZipper, breadcrumbsForOriginalParent);
                newZippers.add(newZipper);
            }
            for (Map.Entry<Object, List<Object>> entry : breadcrumbsUsed.entrySet()) {
                List all = (List)curBreadcrumbsByZipper.get(entry.getKey());
                all.removeAll((Collection)entry.getValue());
                if (all.size() != 0) continue;
                curZippers.remove(entry.getKey());
            }
            curZippers.addAll(newZippers);
        }
    }

    private Map<NodeZipper<GraphQLSchemaElement>, List<List<Breadcrumb<GraphQLSchemaElement>>>> getBreadcrumbsUsed(Set<NodeZipper<GraphQLSchemaElement>> zippers, Map<NodeZipper<GraphQLSchemaElement>, List<List<Breadcrumb<GraphQLSchemaElement>>>> breadcrumbsByZipper, int depth) {
        LinkedHashMap<NodeZipper<GraphQLSchemaElement>, List<List<Breadcrumb<GraphQLSchemaElement>>>> result = new LinkedHashMap<NodeZipper<GraphQLSchemaElement>, List<List<Breadcrumb<GraphQLSchemaElement>>>>();
        for (NodeZipper<GraphQLSchemaElement> zipper : zippers) {
            List<List<Breadcrumb<GraphQLSchemaElement>>> breadcrumbsList = breadcrumbsByZipper.get(zipper);
            for (List<Breadcrumb<GraphQLSchemaElement>> breadcrumbs : breadcrumbsList) {
                if (breadcrumbs.size() != depth) continue;
                result.computeIfAbsent(zipper, ignored -> new ArrayList());
                ((List)result.get(zipper)).add(breadcrumbs);
            }
        }
        return result;
    }

    private int getDeepestZippers(Set<NodeZipper<GraphQLSchemaElement>> zippers, Map<NodeZipper<GraphQLSchemaElement>, List<List<Breadcrumb<GraphQLSchemaElement>>>> breadcrumbsByZipper, List<NodeZipper<GraphQLSchemaElement>> result) {
        Map<Integer, List<NodeZipper>> grouped = FpKit.groupingBy(zippers, astZipper -> {
            List breadcrumbsList = (List)breadcrumbsByZipper.get(astZipper);
            List<Integer> sizes = FpKit.map(breadcrumbsList, List::size);
            return Collections.max(sizes);
        });
        Integer maxLevel = Collections.max(grouped.keySet());
        result.addAll((Collection<NodeZipper<GraphQLSchemaElement>>)grouped.get(maxLevel));
        return maxLevel;
    }

    private NodeZipper<GraphQLSchemaElement> moveUp(GraphQLSchemaElement parent, List<NodeZipper<GraphQLSchemaElement>> sameParent, Map<NodeZipper<GraphQLSchemaElement>, List<List<Breadcrumb<GraphQLSchemaElement>>>> breadcrumbsUsed) {
        Assert.assertNotEmpty(sameParent, () -> "expected at least one zipper");
        HashMap<String, List<GraphQLSchemaElement>> childrenMap = new HashMap<String, List<GraphQLSchemaElement>>(GraphQLSchemaElementAdapter.SCHEMA_ELEMENT_ADAPTER.getNamedChildren(parent));
        HashMap<String, Integer> indexCorrection = new HashMap<String, Integer>();
        ArrayList<ZipperWithOneParent> zipperWithOneParents = new ArrayList<ZipperWithOneParent>();
        for (NodeZipper<GraphQLSchemaElement> zipper : sameParent) {
            for (List<Breadcrumb<GraphQLSchemaElement>> breadcrumbs : breadcrumbsUsed.get(zipper)) {
                if (breadcrumbs.get(0).getNode() != parent) continue;
                zipperWithOneParents.add(new ZipperWithOneParent(zipper, breadcrumbs.get(0)));
            }
        }
        zipperWithOneParents.sort((zipperWithOneParent1, zipperWithOneParent2) -> {
            NodeZipper.ModificationType modificationType2;
            int index2;
            NodeZipper<GraphQLSchemaElement> zipper1 = zipperWithOneParent1.zipper;
            NodeZipper<GraphQLSchemaElement> zipper2 = zipperWithOneParent2.zipper;
            Breadcrumb<GraphQLSchemaElement> breadcrumb1 = zipperWithOneParent1.parent;
            Breadcrumb<GraphQLSchemaElement> breadcrumb2 = zipperWithOneParent2.parent;
            int index1 = breadcrumb1.getLocation().getIndex();
            if (index1 != (index2 = breadcrumb2.getLocation().getIndex())) {
                return Integer.compare(index1, index2);
            }
            NodeZipper.ModificationType modificationType1 = zipper1.getModificationType();
            if (modificationType1 == (modificationType2 = zipper2.getModificationType())) {
                return 0;
            }
            if (modificationType1 == NodeZipper.ModificationType.REPLACE) {
                return -1;
            }
            return modificationType1 == NodeZipper.ModificationType.INSERT_BEFORE ? -1 : 1;
        });
        for (ZipperWithOneParent zipperWithOneParent : zipperWithOneParents) {
            NodeZipper<GraphQLSchemaElement> zipper = zipperWithOneParent.zipper;
            Breadcrumb<GraphQLSchemaElement> breadcrumb = zipperWithOneParent.parent;
            NodeLocation location = breadcrumb.getLocation();
            Integer ixDiff = indexCorrection.getOrDefault(location.getName(), 0);
            int ix = location.getIndex() + ixDiff;
            String name = location.getName();
            ArrayList<GraphQLSchemaElement> childList = new ArrayList<GraphQLSchemaElement>((Collection)childrenMap.get(name));
            switch (zipper.getModificationType()) {
                case REPLACE: {
                    childList.set(ix, zipper.getCurNode());
                    break;
                }
                case DELETE: {
                    childList.remove(ix);
                    indexCorrection.put(name, ixDiff - 1);
                    break;
                }
                case INSERT_BEFORE: {
                    childList.add(ix, zipper.getCurNode());
                    indexCorrection.put(name, ixDiff + 1);
                    break;
                }
                case INSERT_AFTER: {
                    childList.add(ix + 1, zipper.getCurNode());
                    indexCorrection.put(name, ixDiff + 1);
                }
            }
            childrenMap.put(name, childList);
        }
        GraphQLSchemaElement newNode = GraphQLSchemaElementAdapter.SCHEMA_ELEMENT_ADAPTER.withNewChildren(parent, (Map<String, List<GraphQLSchemaElement>>)childrenMap);
        List newBreadcrumbs = sameParent.get(0).getBreadcrumbs().subList(1, sameParent.get(0).getBreadcrumbs().size());
        return new NodeZipper<GraphQLSchemaElement>(newNode, newBreadcrumbs, GraphQLSchemaElementAdapter.SCHEMA_ELEMENT_ADAPTER);
    }

    private Map<GraphQLSchemaElement, List<NodeZipper<GraphQLSchemaElement>>> groupBySameParent(List<NodeZipper<GraphQLSchemaElement>> zippers, Map<NodeZipper<GraphQLSchemaElement>, List<List<Breadcrumb<GraphQLSchemaElement>>>> breadcrumbsByZipper) {
        LinkedHashMap<GraphQLSchemaElement, List<NodeZipper<GraphQLSchemaElement>>> result = new LinkedHashMap<GraphQLSchemaElement, List<NodeZipper<GraphQLSchemaElement>>>();
        for (NodeZipper<GraphQLSchemaElement> zipper : zippers) {
            for (List<Breadcrumb<GraphQLSchemaElement>> breadcrumbs : breadcrumbsByZipper.get(zipper)) {
                GraphQLSchemaElement parent = breadcrumbs.get(0).getNode();
                result.computeIfAbsent(parent, ignored -> new ArrayList());
                ((List)result.get(parent)).add(zipper);
            }
        }
        return result;
    }

    private static class ZipperWithOneParent {
        public NodeZipper<GraphQLSchemaElement> zipper;
        public Breadcrumb<GraphQLSchemaElement> parent;

        public ZipperWithOneParent(NodeZipper<GraphQLSchemaElement> zipper, Breadcrumb<GraphQLSchemaElement> parent) {
            this.zipper = zipper;
            this.parent = parent;
        }
    }

    private static class DummyRoot
    implements GraphQLSchemaElement {
        static final String QUERY = "query";
        static final String MUTATION = "mutation";
        static final String SUBSCRIPTION = "subscription";
        static final String ADD_TYPES = "addTypes";
        static final String DIRECTIVES = "directives";
        static final String INTROSPECTION = "introspection";
        GraphQLSchema schema;
        GraphQLObjectType query;
        GraphQLObjectType mutation;
        GraphQLObjectType subscription;
        Set<GraphQLType> additionalTypes;
        Set<GraphQLDirective> directives;

        DummyRoot(GraphQLSchema schema) {
            this.schema = schema;
            this.query = schema.getQueryType();
            this.mutation = schema.isSupportingMutations() ? schema.getMutationType() : null;
            this.subscription = schema.isSupportingSubscriptions() ? schema.getSubscriptionType() : null;
            this.additionalTypes = schema.getAdditionalTypes();
            this.directives = new LinkedHashSet<GraphQLDirective>(schema.getDirectives());
        }

        @Override
        public List<GraphQLSchemaElement> getChildren() {
            return (List)Assert.assertShouldNeverHappen();
        }

        @Override
        public SchemaElementChildrenContainer getChildrenWithTypeReferences() {
            SchemaElementChildrenContainer.Builder builder = SchemaElementChildrenContainer.newSchemaElementChildrenContainer().child(QUERY, this.query);
            if (this.schema.isSupportingMutations()) {
                builder.child(MUTATION, this.mutation);
            }
            if (this.schema.isSupportingSubscriptions()) {
                builder.child(SUBSCRIPTION, this.subscription);
            }
            builder.children(ADD_TYPES, this.additionalTypes);
            builder.children(DIRECTIVES, this.directives);
            builder.child(INTROSPECTION, Introspection.__Schema);
            return builder.build();
        }

        @Override
        public GraphQLSchemaElement withNewChildren(SchemaElementChildrenContainer newChildren) {
            this.query = (GraphQLObjectType)newChildren.getChildOrNull(QUERY);
            this.mutation = (GraphQLObjectType)newChildren.getChildOrNull(MUTATION);
            this.subscription = (GraphQLObjectType)newChildren.getChildOrNull(SUBSCRIPTION);
            this.additionalTypes = new LinkedHashSet(newChildren.getChildren(ADD_TYPES));
            this.directives = new LinkedHashSet(newChildren.getChildren(DIRECTIVES));
            return this;
        }

        @Override
        public TraversalControl accept(TraverserContext<GraphQLSchemaElement> context, GraphQLTypeVisitor visitor) {
            return (TraversalControl)((Object)Assert.assertShouldNeverHappen());
        }
    }
}

