/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.GraphQLError;
import graphql.Internal;
import graphql.language.AstPrinter;
import graphql.language.FieldDefinition;
import graphql.language.ImplementingTypeDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.InterfaceTypeExtensionDefinition;
import graphql.language.NonNullType;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ObjectTypeExtensionDefinition;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.TypeInfo;
import graphql.schema.idl.errors.InterfaceFieldArgumentNotOptionalError;
import graphql.schema.idl.errors.InterfaceFieldArgumentRedefinitionError;
import graphql.schema.idl.errors.InterfaceFieldRedefinitionError;
import graphql.schema.idl.errors.InterfaceImplementedMoreThanOnceError;
import graphql.schema.idl.errors.InterfaceImplementingItselfError;
import graphql.schema.idl.errors.InterfaceWithCircularImplementationHierarchyError;
import graphql.schema.idl.errors.MissingInterfaceFieldArgumentsError;
import graphql.schema.idl.errors.MissingInterfaceFieldError;
import graphql.schema.idl.errors.MissingTransitiveInterfaceError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Internal
class ImplementingTypesChecker {
    private static final Map<Class<? extends ImplementingTypeDefinition>, String> TYPE_OF_MAP = new HashMap<Class<? extends ImplementingTypeDefinition>, String>();

    ImplementingTypesChecker() {
    }

    void checkImplementingTypes(List<GraphQLError> errors, TypeDefinitionRegistry typeRegistry) {
        List<InterfaceTypeDefinition> interfaces = typeRegistry.getTypes(InterfaceTypeDefinition.class);
        List<ObjectTypeDefinition> objects = typeRegistry.getTypes(ObjectTypeDefinition.class);
        Stream.of(interfaces.stream(), objects.stream()).flatMap(Function.identity()).forEach(type -> this.checkImplementingType(errors, typeRegistry, (ImplementingTypeDefinition)((Object)type)));
    }

    private void checkImplementingType(List<GraphQLError> errors, TypeDefinitionRegistry typeRegistry, ImplementingTypeDefinition type) {
        Map<InterfaceTypeDefinition, ImplementingTypeDefinition> implementedInterfaces = this.checkInterfacesNotImplementedMoreThanOnce(errors, type, typeRegistry);
        this.checkInterfaceIsImplemented(errors, typeRegistry, type, implementedInterfaces);
        this.checkAncestorImplementation(errors, typeRegistry, type, implementedInterfaces);
    }

    private Map<InterfaceTypeDefinition, ImplementingTypeDefinition> checkInterfacesNotImplementedMoreThanOnce(List<GraphQLError> errors, ImplementingTypeDefinition type, TypeDefinitionRegistry typeRegistry) {
        Map<InterfaceTypeDefinition, List<ImplementingTypeDefinition>> implementedInterfaces = this.getLogicallyImplementedInterfaces(type, typeRegistry);
        Map<InterfaceTypeDefinition, ImplementingTypeDefinition> interfacesImplementedOnce = implementedInterfaces.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() == 1).collect(Collectors.toMap(Map.Entry::getKey, entry -> (ImplementingTypeDefinition)((List)entry.getValue()).get(0)));
        implementedInterfaces.entrySet().stream().filter(entry -> !interfacesImplementedOnce.containsKey(entry.getKey())).forEach(entry -> ((List)entry.getValue()).forEach(offendingType -> errors.add(new InterfaceImplementedMoreThanOnceError(TYPE_OF_MAP.get(offendingType.getClass()), (ImplementingTypeDefinition)offendingType, (InterfaceTypeDefinition)entry.getKey()))));
        return interfacesImplementedOnce;
    }

    private void checkAncestorImplementation(List<GraphQLError> errors, TypeDefinitionRegistry typeRegistry, ImplementingTypeDefinition type, Map<InterfaceTypeDefinition, ImplementingTypeDefinition> implementedInterfaces) {
        if (implementedInterfaces.containsKey(type)) {
            errors.add(new InterfaceImplementingItselfError(TYPE_OF_MAP.get(type.getClass()), type));
            return;
        }
        implementedInterfaces.forEach((implementedInterface, implementingType) -> {
            Set<InterfaceTypeDefinition> transitiveInterfaces = this.getLogicallyImplementedInterfaces((ImplementingTypeDefinition)implementedInterface, typeRegistry).keySet();
            transitiveInterfaces.forEach(transitiveInterface -> {
                if (transitiveInterface.equals(type)) {
                    errors.add(new InterfaceWithCircularImplementationHierarchyError(TYPE_OF_MAP.get(type.getClass()), type, (InterfaceTypeDefinition)implementedInterface));
                } else if (!implementedInterfaces.containsKey(transitiveInterface)) {
                    errors.add(new MissingTransitiveInterfaceError(TYPE_OF_MAP.get(implementingType.getClass()), (ImplementingTypeDefinition)implementingType, (InterfaceTypeDefinition)implementedInterface, (InterfaceTypeDefinition)transitiveInterface));
                }
            });
        });
    }

    private void checkInterfaceIsImplemented(List<GraphQLError> errors, TypeDefinitionRegistry typeRegistry, ImplementingTypeDefinition type, Map<InterfaceTypeDefinition, ImplementingTypeDefinition> implementedInterfaces) {
        Set<FieldDefinition> fieldDefinitions = this.getLogicallyDeclaredFields(type, typeRegistry);
        Map typeFields = fieldDefinitions.stream().collect(Collectors.toMap(FieldDefinition::getName, Function.identity(), this.mergeFirstValue()));
        implementedInterfaces.forEach((implementedInterface, implementingType) -> implementedInterface.getFieldDefinitions().forEach(interfaceFieldDef -> {
            FieldDefinition typeFieldDef = (FieldDefinition)typeFields.get(interfaceFieldDef.getName());
            if (typeFieldDef == null) {
                errors.add(new MissingInterfaceFieldError(TYPE_OF_MAP.get(implementingType.getClass()), (ImplementingTypeDefinition)implementingType, (InterfaceTypeDefinition)implementedInterface, (FieldDefinition)interfaceFieldDef));
            } else {
                if (!typeRegistry.isSubTypeOf(typeFieldDef.getType(), interfaceFieldDef.getType())) {
                    String interfaceFieldType = AstPrinter.printAst(interfaceFieldDef.getType());
                    String objectFieldType = AstPrinter.printAst(typeFieldDef.getType());
                    errors.add(new InterfaceFieldRedefinitionError(TYPE_OF_MAP.get(implementingType.getClass()), (ImplementingTypeDefinition)implementingType, (InterfaceTypeDefinition)implementedInterface, typeFieldDef, objectFieldType, interfaceFieldType));
                }
                List<InputValueDefinition> objectArgs = typeFieldDef.getInputValueDefinitions();
                List<InputValueDefinition> interfaceArgs = interfaceFieldDef.getInputValueDefinitions();
                if (objectArgs.size() < interfaceArgs.size()) {
                    errors.add(new MissingInterfaceFieldArgumentsError(TYPE_OF_MAP.get(implementingType.getClass()), (ImplementingTypeDefinition)implementingType, (InterfaceTypeDefinition)implementedInterface, typeFieldDef));
                } else {
                    this.checkArgumentConsistency(TYPE_OF_MAP.get(implementingType.getClass()), (ImplementingTypeDefinition)implementingType, (InterfaceTypeDefinition)implementedInterface, typeFieldDef, (FieldDefinition)interfaceFieldDef, errors);
                }
            }
        }));
    }

    private void checkArgumentConsistency(String typeOfType, ImplementingTypeDefinition objectTypeDef, InterfaceTypeDefinition interfaceTypeDef, FieldDefinition objectFieldDef, FieldDefinition interfaceFieldDef, List<GraphQLError> errors) {
        int i;
        List<InputValueDefinition> objectArgs = objectFieldDef.getInputValueDefinitions();
        List<InputValueDefinition> interfaceArgs = interfaceFieldDef.getInputValueDefinitions();
        for (i = 0; i < interfaceArgs.size(); ++i) {
            String objectArgStr;
            InputValueDefinition interfaceArg = interfaceArgs.get(i);
            InputValueDefinition objectArg = objectArgs.get(i);
            String interfaceArgStr = AstPrinter.printAstCompact(interfaceArg);
            if (interfaceArgStr.equals(objectArgStr = AstPrinter.printAstCompact(objectArg))) continue;
            errors.add(new InterfaceFieldArgumentRedefinitionError(typeOfType, objectTypeDef, interfaceTypeDef, objectFieldDef, objectArgStr, interfaceArgStr));
        }
        if (objectArgs.size() > interfaceArgs.size()) {
            for (i = interfaceArgs.size(); i < objectArgs.size(); ++i) {
                InputValueDefinition objectArg = objectArgs.get(i);
                if (!(objectArg.getType() instanceof NonNullType)) continue;
                String objectArgStr = AstPrinter.printAst(objectArg);
                errors.add(new InterfaceFieldArgumentNotOptionalError(typeOfType, objectTypeDef, interfaceTypeDef, objectFieldDef, objectArgStr));
            }
        }
    }

    private Map<InterfaceTypeDefinition, List<ImplementingTypeDefinition>> getLogicallyImplementedInterfaces(ImplementingTypeDefinition type, TypeDefinitionRegistry typeRegistry) {
        Stream extensions = Stream.concat(typeRegistry.interfaceTypeExtensions().getOrDefault(type.getName(), Collections.emptyList()).stream(), typeRegistry.objectTypeExtensions().getOrDefault(type.getName(), Collections.emptyList()).stream());
        return Stream.concat(Stream.of(type), extensions).collect(HashMap::new, (map, implementingType) -> {
            List<Type> implementedInterfaces = implementingType.getImplements();
            this.toInterfaceTypeDefinitions(typeRegistry, implementedInterfaces).forEach(implemented -> {
                List implementingTypes = map.getOrDefault(implemented, new ArrayList());
                implementingTypes.add(implementingType);
                map.put(implemented, implementingTypes);
            });
        }, HashMap::putAll);
    }

    private Set<FieldDefinition> getLogicallyDeclaredFields(ImplementingTypeDefinition type, TypeDefinitionRegistry typeRegistry) {
        Stream extensions = Stream.concat(typeRegistry.interfaceTypeExtensions().getOrDefault(type.getName(), Collections.emptyList()).stream(), typeRegistry.objectTypeExtensions().getOrDefault(type.getName(), Collections.emptyList()).stream());
        return Stream.concat(Stream.of(type), extensions).flatMap(implementingType -> {
            List<FieldDefinition> fieldDefinitions = implementingType.getFieldDefinitions();
            return fieldDefinitions.stream();
        }).collect(Collectors.toSet());
    }

    private <T> BinaryOperator<T> mergeFirstValue() {
        return (v1, v2) -> v1;
    }

    private Optional<InterfaceTypeDefinition> toInterfaceTypeDefinition(Type type, TypeDefinitionRegistry typeRegistry) {
        TypeInfo typeInfo = TypeInfo.typeInfo(type);
        TypeName unwrapped = typeInfo.getTypeName();
        return typeRegistry.getType(unwrapped, InterfaceTypeDefinition.class);
    }

    private Set<InterfaceTypeDefinition> toInterfaceTypeDefinitions(TypeDefinitionRegistry typeRegistry, Collection<Type> implementsTypes) {
        return implementsTypes.stream().map(t -> this.toInterfaceTypeDefinition((Type)t, typeRegistry)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    static {
        TYPE_OF_MAP.put(ObjectTypeDefinition.class, "object");
        TYPE_OF_MAP.put(ObjectTypeExtensionDefinition.class, "object extension");
        TYPE_OF_MAP.put(InterfaceTypeDefinition.class, "interface");
        TYPE_OF_MAP.put(InterfaceTypeExtensionDefinition.class, "interface extension");
    }
}

