/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.Scalars;
import graphql.language.ScalarTypeDefinition;
import graphql.schema.GraphQLScalarType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ScalarInfo {
    public static final List<GraphQLScalarType> GRAPHQL_SPECIFICATION_SCALARS = new ArrayList<GraphQLScalarType>();
    public static final Map<String, ScalarTypeDefinition> GRAPHQL_SPECIFICATION_SCALARS_DEFINITIONS = new LinkedHashMap<String, ScalarTypeDefinition>();

    public static boolean isGraphqlSpecifiedScalar(String scalarTypeName) {
        return ScalarInfo.inList(GRAPHQL_SPECIFICATION_SCALARS, scalarTypeName);
    }

    public static boolean isGraphqlSpecifiedScalar(GraphQLScalarType scalarType) {
        return ScalarInfo.inList(GRAPHQL_SPECIFICATION_SCALARS, scalarType.getName());
    }

    private static boolean inList(List<GraphQLScalarType> scalarList, String scalarTypeName) {
        return scalarList.stream().anyMatch(sc -> sc.getName().equals(scalarTypeName));
    }

    static {
        GRAPHQL_SPECIFICATION_SCALARS.add(Scalars.GraphQLInt);
        GRAPHQL_SPECIFICATION_SCALARS.add(Scalars.GraphQLFloat);
        GRAPHQL_SPECIFICATION_SCALARS.add(Scalars.GraphQLString);
        GRAPHQL_SPECIFICATION_SCALARS.add(Scalars.GraphQLBoolean);
        GRAPHQL_SPECIFICATION_SCALARS.add(Scalars.GraphQLID);
        GRAPHQL_SPECIFICATION_SCALARS_DEFINITIONS.put("Int", ScalarTypeDefinition.newScalarTypeDefinition().name("Int").build());
        GRAPHQL_SPECIFICATION_SCALARS_DEFINITIONS.put("Float", ScalarTypeDefinition.newScalarTypeDefinition().name("Float").build());
        GRAPHQL_SPECIFICATION_SCALARS_DEFINITIONS.put("String", ScalarTypeDefinition.newScalarTypeDefinition().name("String").build());
        GRAPHQL_SPECIFICATION_SCALARS_DEFINITIONS.put("Boolean", ScalarTypeDefinition.newScalarTypeDefinition().name("Boolean").build());
        GRAPHQL_SPECIFICATION_SCALARS_DEFINITIONS.put("ID", ScalarTypeDefinition.newScalarTypeDefinition().name("ID").build());
    }
}

