/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.Assert;
import graphql.Internal;
import graphql.language.NamedNode;
import graphql.language.NodeParentTree;
import graphql.schema.DataFetcher;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphqlElementParentTree;
import graphql.schema.idl.SchemaDirectiveWiringEnvironment;
import graphql.schema.idl.SchemaGeneratorDirectiveHelper;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.util.FpKit;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Internal
public class SchemaDirectiveWiringEnvironmentImpl<T extends GraphQLDirectiveContainer>
implements SchemaDirectiveWiringEnvironment<T> {
    private final T element;
    private final Map<String, GraphQLDirective> directives;
    private final NodeParentTree<NamedNode> nodeParentTree;
    private final TypeDefinitionRegistry typeDefinitionRegistry;
    private final Map<String, Object> context;
    private final GraphQLCodeRegistry.Builder codeRegistry;
    private final GraphqlElementParentTree elementParentTree;
    private final GraphQLFieldsContainer fieldsContainer;
    private final GraphQLFieldDefinition fieldDefinition;
    private final GraphQLDirective registeredDirective;

    public SchemaDirectiveWiringEnvironmentImpl(T element, List<GraphQLDirective> directives, GraphQLDirective registeredDirective, SchemaGeneratorDirectiveHelper.Parameters parameters) {
        this.element = element;
        this.registeredDirective = registeredDirective;
        this.typeDefinitionRegistry = parameters.getTypeRegistry();
        this.directives = FpKit.getByName(directives, GraphQLDirective::getName);
        this.context = parameters.getContext();
        this.codeRegistry = parameters.getCodeRegistry();
        this.nodeParentTree = parameters.getNodeParentTree();
        this.elementParentTree = parameters.getElementParentTree();
        this.fieldsContainer = parameters.getFieldsContainer();
        this.fieldDefinition = parameters.getFieldsDefinition();
    }

    @Override
    public T getElement() {
        return this.element;
    }

    @Override
    public GraphQLDirective getDirective() {
        return this.registeredDirective;
    }

    @Override
    public Map<String, GraphQLDirective> getDirectives() {
        return new LinkedHashMap<String, GraphQLDirective>(this.directives);
    }

    @Override
    public GraphQLDirective getDirective(String directiveName) {
        return this.directives.get(directiveName);
    }

    @Override
    public boolean containsDirective(String directiveName) {
        return this.directives.containsKey(directiveName);
    }

    @Override
    public NodeParentTree<NamedNode> getNodeParentTree() {
        return this.nodeParentTree;
    }

    @Override
    public TypeDefinitionRegistry getRegistry() {
        return this.typeDefinitionRegistry;
    }

    @Override
    public Map<String, Object> getBuildContext() {
        return this.context;
    }

    @Override
    public GraphQLCodeRegistry.Builder getCodeRegistry() {
        return this.codeRegistry;
    }

    @Override
    public GraphQLFieldsContainer getFieldsContainer() {
        return this.fieldsContainer;
    }

    @Override
    public GraphqlElementParentTree getElementParentTree() {
        return this.elementParentTree;
    }

    @Override
    public GraphQLFieldDefinition getFieldDefinition() {
        return this.fieldDefinition;
    }

    @Override
    public DataFetcher getFieldDataFetcher() {
        Assert.assertNotNull(this.fieldDefinition, () -> "An output field must be in context to call this method");
        Assert.assertNotNull(this.fieldsContainer, () -> "An output field container must be in context to call this method");
        return this.codeRegistry.getDataFetcher(this.fieldsContainer, this.fieldDefinition);
    }

    @Override
    public GraphQLFieldDefinition setFieldDataFetcher(DataFetcher newDataFetcher) {
        Assert.assertNotNull(this.fieldDefinition, () -> "An output field must be in context to call this method");
        Assert.assertNotNull(this.fieldsContainer, () -> "An output field container must be in context to call this method");
        FieldCoordinates coordinates = FieldCoordinates.coordinates(this.fieldsContainer, this.fieldDefinition);
        this.codeRegistry.dataFetcher(coordinates, newDataFetcher);
        return this.fieldDefinition;
    }
}

