/*
 * Decompiled with CFR 0.152.
 */
package graphql.util;

import graphql.Assert;
import java.util.function.Supplier;

class MemoizedSupplier<T>
implements Supplier<T> {
    private static final Object SENTINEL = new Object(){};
    private T value = SENTINEL;
    private final Supplier<T> delegate;

    MemoizedSupplier(Supplier<T> delegate) {
        this.delegate = Assert.assertNotNull(delegate);
    }

    @Override
    public T get() {
        T t = this.value;
        if (t == SENTINEL) {
            this.value = t = this.delegate.get();
        }
        return t;
    }
}

