/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.Directives;
import graphql.Internal;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationError;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Internal
public class DeferredMustBeOnAllFields
extends AbstractRule {
    private final Map<List<String>, List<Field>> fieldsByPath = new LinkedHashMap<List<String>, List<Field>>();

    public DeferredMustBeOnAllFields(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
    }

    @Override
    public void documentFinished(Document document) {
        this.fieldsByPath.forEach((path, allFieldsOnPath) -> {
            Map<String, List<Field>> fieldsByName = allFieldsOnPath.stream().collect(Collectors.groupingBy(Field::getName));
            fieldsByName.forEach((fieldName, fields) -> {
                if (fields.size() > 1 && !this.allFieldsHaveDeferredDirectiveIfAnyOneDoes((List<Field>)fields)) {
                    this.recordBadDeferredFields((List<String>)path, (String)fieldName, (List<Field>)fields);
                }
            });
        });
    }

    private boolean allFieldsHaveDeferredDirectiveIfAnyOneDoes(List<Field> fields) {
        long count = fields.stream().filter(fld -> fld.getDirective(Directives.DeferDirective.getName()) != null).count();
        if (count == 0L) {
            return true;
        }
        return count == (long)fields.size();
    }

    private void recordBadDeferredFields(List<String> path, String fieldName, List<Field> fields) {
        String message = String.format("If any of the multiple declarations of a field within the query (via fragments and field selections) contain the @defer directive, then all of them have to contain the @defer directive - field '%s' at '%s'", fieldName, path);
        this.getValidationErrorCollector().addError(new ValidationError(ValidationErrorType.DeferMustBeOnAllFields, fields.get(0).getSourceLocation(), message, path));
    }

    @Override
    public void checkSelectionSet(SelectionSet selectionSet) {
        List<String> queryPath = this.getValidationContext().getQueryPath();
        ArrayList seenSelections = new ArrayList();
        this.addFields(queryPath, selectionSet, seenSelections);
    }

    private void addFields(List<String> path, SelectionSet selectionSet, List<Selection<?>> seenSelections) {
        if (path == null) {
            path = Collections.emptyList();
        }
        for (Selection selection : selectionSet.getSelections()) {
            if (seenSelections.contains(selection)) break;
            seenSelections.add(selection);
            if (selection instanceof Field) {
                List fields = this.fieldsByPath.getOrDefault(path, new ArrayList());
                fields.add((Field)selection);
                this.fieldsByPath.put(path, fields);
            }
            if (selection instanceof InlineFragment) {
                this.addFields(path, ((InlineFragment)selection).getSelectionSet(), seenSelections);
            }
            if (!(selection instanceof FragmentSpread)) continue;
            FragmentSpread fragmentSpread = (FragmentSpread)selection;
            FragmentDefinition fragmentDefinition = this.getValidationContext().getFragment(fragmentSpread.getName());
            if (fragmentDefinition == null) continue;
            this.addFields(path, fragmentDefinition.getSelectionSet(), seenSelections);
        }
    }
}

