/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.search.client.noop;

import io.apicurio.registry.search.client.SearchClient;
import io.apicurio.registry.search.client.SearchResponse;
import io.apicurio.registry.search.client.SearchResults;
import io.apicurio.registry.search.common.Search;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class NoopSearchClient
implements SearchClient {
    private static final SearchResults INSTANCE = new NoopSearchResults();

    public NoopSearchClient() {
    }

    public NoopSearchClient(Properties properties) {
    }

    @Override
    public CompletionStage<Boolean> initialize(boolean reset) {
        return CompletableFuture.completedFuture(Boolean.TRUE);
    }

    @Override
    public CompletionStage<SearchResponse> index(Search.Artifact artifact) {
        return CompletableFuture.completedFuture(INSTANCE);
    }

    @Override
    public CompletionStage<SearchResults> search(String query) {
        return CompletableFuture.completedFuture(INSTANCE);
    }

    @Override
    public void close() {
    }

    private static class NoopSearchResults
    implements SearchResults {
        private NoopSearchResults() {
        }

        @Override
        public int getTotalHits() {
            return 0;
        }

        @Override
        public List<Search.Artifact> getArtifacts() {
            return Collections.emptyList();
        }

        @Override
        public boolean ok() {
            return false;
        }

        @Override
        public int status() {
            return 0;
        }
    }
}

