/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils;

import io.apicurio.registry.utils.RegistryProperties;
import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.enterprise.inject.spi.InjectionPoint;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesUtil {
    private static final Logger log = LoggerFactory.getLogger(PropertiesUtil.class);
    private static final boolean debug = Boolean.getBoolean("registry.debug");

    public static Properties properties(InjectionPoint ip) {
        RegistryProperties cp = (RegistryProperties)ip.getAnnotated().getAnnotation(RegistryProperties.class);
        if (cp == null) {
            throw new IllegalArgumentException(ip.getMember() + " is not annotated with @RegistryProperties");
        }
        Object[] prefixes = (String[])Stream.of(cp.value()).map(pfx -> pfx.isEmpty() || pfx.endsWith(".") ? pfx : pfx + ".").distinct().toArray(String[]::new);
        if (prefixes.length == 0) {
            throw new IllegalArgumentException("Annotation @RegistryProperties on " + ip.getMember() + " is missing non-empty 'value' attribute");
        }
        Properties properties = new Properties();
        Config config = ConfigProviderResolver.instance().getConfig();
        if (debug && log.isDebugEnabled()) {
            String string = StreamSupport.stream(config.getPropertyNames().spliterator(), false).sorted().map(key -> key + "=" + config.getOptionalValue(key, String.class).orElse("")).collect(Collectors.joining("\n  ", "  ", "\n"));
            log.debug("Injecting config properties with prefixes {} into {} from the following...\n{}", new Object[]{Arrays.toString(prefixes), ip.getMember(), string});
        }
        for (String string : prefixes) {
            for (String key2 : config.getPropertyNames()) {
                if (!key2.startsWith(string)) continue;
                Optional value = config.getOptionalValue(key2, String.class);
                value.ifPresent(s -> properties.setProperty(key2.substring(prefix.length()), (String)s));
            }
        }
        if (debug && log.isDebugEnabled()) {
            String string = properties.stringPropertyNames().stream().sorted().map(key -> key + "=" + properties.getProperty((String)key)).collect(Collectors.joining("\n  ", "  ", "\n"));
            log.debug("... selected/prefix-stripped properties are:\n{}", (Object)string);
        }
        return properties;
    }
}

