/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.apicurio.registry.common.proto.Cmmn;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class ProtoUtil {
    public static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static String emptyAsNull(String protoString) {
        return ProtoUtil.isEmpty(protoString) ? null : protoString;
    }

    public static String nullAsEmpty(String nullableString) {
        return nullableString == null ? "" : nullableString;
    }

    public static <B, R> R getNullable(B b, Predicate<? super B> tester, Function<? super B, ? extends R> getter) {
        return tester.test(b) ? (R)getter.apply((B)b) : null;
    }

    public static <B, T, R> R getNullable(B b, Predicate<? super B> tester, Function<? super B, ? extends T> getter, Function<? super T, ? extends R> converter) {
        return tester.test(b) ? (R)converter.apply((T)getter.apply(b)) : null;
    }

    public static <B, R> B setNullable(B b, R r, Consumer<? super B> clearer, BiConsumer<? super B, ? super R> setter) {
        return ProtoUtil.setNullable(b, r, clearer, setter, Function.identity());
    }

    public static <B, T, R> B setNullable(B b, R r, Consumer<? super B> clearer, BiConsumer<? super B, ? super T> setter, Function<? super R, ? extends T> converter) {
        if (r == null) {
            clearer.accept(b);
        } else {
            setter.accept(b, converter.apply(r));
        }
        return b;
    }

    public static String toJson(Message msg) throws InvalidProtocolBufferException {
        JsonFormat.Printer printer = JsonFormat.printer().omittingInsignificantWhitespace().usingTypeRegistry(JsonFormat.TypeRegistry.newBuilder().add(msg.getDescriptorForType()).build());
        return printer.print((MessageOrBuilder)msg);
    }

    public static <T> T fromJson(Message.Builder builder, String json, boolean ignoreUnknownFields) throws InvalidProtocolBufferException {
        JsonFormat.Parser parser = JsonFormat.parser();
        if (ignoreUnknownFields) {
            parser = parser.ignoringUnknownFields();
        }
        parser.merge(json, builder);
        return (T)builder.build();
    }

    public static UUID convert(Cmmn.UUID mpUuid) {
        return new UUID(mpUuid.getMsb(), mpUuid.getLsb());
    }

    public static Cmmn.UUID convert(UUID uuid) {
        return Cmmn.UUID.newBuilder().setMsb(uuid.getMostSignificantBits()).setLsb(uuid.getLeastSignificantBits()).build();
    }
}

