/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.content.canon;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.canon.ContentCanonicalizer;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.avro.Schema;

public class AvroContentCanonicalizer
implements ContentCanonicalizer {
    private final ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);
    private final Comparator<JsonNode> fieldComparator = (n1, n2) -> {
        String name1 = n1.get("name").textValue();
        String name2 = n2.get("name").textValue();
        return name1.compareTo(name2);
    };

    @Override
    public ContentHandle canonicalize(ContentHandle content) {
        try {
            JsonNode root = this.mapper.readTree(content.content());
            JsonNode fieldsNode = root.get("fields");
            if (fieldsNode != null) {
                TreeSet<JsonNode> fields = new TreeSet<JsonNode>(this.fieldComparator);
                Iterator elements = fieldsNode.elements();
                while (elements.hasNext()) {
                    fields.add((JsonNode)elements.next());
                }
                ArrayNode array = new ArrayNode(this.mapper.getNodeFactory());
                fields.forEach(arg_0 -> ((ArrayNode)array).add(arg_0));
                ((ObjectNode)ObjectNode.class.cast(root)).replace("fields", (JsonNode)array);
            }
            String converted = this.mapper.writeValueAsString(this.mapper.treeToValue((TreeNode)root, Object.class));
            return ContentHandle.create(converted);
        }
        catch (Throwable t) {
            return ContentHandle.create(new Schema.Parser().parse(content.content()).toString());
        }
    }
}

