/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.content.extract;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.extract.ContentExtractor;
import io.apicurio.registry.rest.beans.EditableMetaData;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonContentExtractor
implements ContentExtractor {
    private static final Logger log = LoggerFactory.getLogger(JsonContentExtractor.class);
    public static final ContentExtractor INSTANCE = new JsonContentExtractor();
    private ObjectMapper mapper = new ObjectMapper();

    private JsonContentExtractor() {
    }

    @Override
    public EditableMetaData extract(ContentHandle content) {
        try {
            JsonNode jsonSchema = this.mapper.readTree(content.bytes());
            JsonNode title = jsonSchema.get("title");
            JsonNode desc = jsonSchema.get("description");
            EditableMetaData metaData = null;
            if (title != null && !title.isNull()) {
                metaData = new EditableMetaData();
                metaData.setName(title.asText());
            }
            if (desc != null && !desc.isNull()) {
                if (metaData == null) {
                    metaData = new EditableMetaData();
                }
                metaData.setDescription(desc.asText());
            }
            return metaData;
        }
        catch (IOException e) {
            log.warn("Error extracting metadata from JSON: {}", (Object)e.getMessage());
            return null;
        }
    }
}

