/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.content.extract;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.extract.ContentExtractor;
import io.apicurio.registry.rest.beans.EditableMetaData;
import io.apicurio.registry.util.DocumentBuilderAccessor;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class WsdlOrXsdContentExtractor
implements ContentExtractor {
    private static final Logger log = LoggerFactory.getLogger(WsdlOrXsdContentExtractor.class);
    public static final ContentExtractor INSTANCE = new WsdlOrXsdContentExtractor();

    private WsdlOrXsdContentExtractor() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public EditableMetaData extract(ContentHandle content) {
        try (InputStream contentIS = content.stream();){
            Document document = DocumentBuilderAccessor.getDocumentBuilder().parse(contentIS);
            String name = document.getDocumentElement().getAttribute("name");
            String targetNS = document.getDocumentElement().getAttribute("targetNamespace");
            EditableMetaData metaData = null;
            if (name != null && !name.equals("")) {
                metaData = new EditableMetaData();
                metaData.setName(name);
            } else if (targetNS != null && !targetNS.equals("")) {
                metaData = new EditableMetaData();
                metaData.setName(targetNS);
            }
            EditableMetaData editableMetaData = metaData;
            return editableMetaData;
        }
        catch (Exception e) {
            log.warn("Error extracting metadata from WSDL/XSD: {}", (Object)e.getMessage());
            return null;
        }
    }
}

