/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.metrics;

import io.apicurio.registry.metrics.LivenessUtil;
import io.apicurio.registry.metrics.PersistenceExceptionLivenessApply;
import io.apicurio.registry.metrics.PersistenceExceptionLivenessCheck;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;

@Interceptor
@PersistenceExceptionLivenessApply
public class PersistenceExceptionLivenessInterceptor {
    @Inject
    PersistenceExceptionLivenessCheck check;
    @Inject
    LivenessUtil livenessUtil;

    @AroundInvoke
    public Object intercept(InvocationContext context) throws Exception {
        try {
            return context.proceed();
        }
        catch (Exception ex) {
            if (!this.livenessUtil.isIgnoreError(ex)) {
                this.check.suspectWithException(ex);
            }
            throw ex;
        }
    }
}

