/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.metrics;

import io.apicurio.registry.metrics.AbstractErrorCounterHealthCheck;
import java.time.Duration;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Default;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.Liveness;

@ApplicationScoped
@Liveness
@Default
public class PersistenceTimeoutReadinessCheck
extends AbstractErrorCounterHealthCheck
implements HealthCheck {
    @ConfigProperty(name="registry.metrics.PersistenceTimeoutReadinessCheck.errorThreshold", defaultValue="5")
    Integer configErrorThreshold;
    @ConfigProperty(name="registry.metrics.PersistenceTimeoutReadinessCheck.counterResetWindowDurationSec", defaultValue="60")
    Integer configCounterResetWindowDurationSec;
    @ConfigProperty(name="registry.metrics.PersistenceTimeoutReadinessCheck.statusResetWindowDurationSec", defaultValue="300")
    Integer configStatusResetWindowDurationSec;
    @ConfigProperty(name="registry.metrics.PersistenceTimeoutReadinessCheck.timeoutSec", defaultValue="15")
    Integer configTimeoutSec;
    private Duration timeoutSec;

    @PostConstruct
    void init() {
        this.init(this.configErrorThreshold, this.configCounterResetWindowDurationSec, this.configStatusResetWindowDurationSec);
        this.timeoutSec = Duration.ofSeconds(this.configTimeoutSec.intValue());
    }

    public synchronized HealthCheckResponse call() {
        this.callSuper();
        return HealthCheckResponse.builder().name("PersistenceTimeoutReadinessCheck").withData("errorCount", this.errorCounter).state(this.up).build();
    }

    public Duration getTimeoutSec() {
        return this.timeoutSec;
    }
}

