/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.metrics;

import io.apicurio.registry.metrics.RestMetricsResponseFilteredNameBinding;
import io.smallrye.metrics.app.Clock;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.ws.rs.Path;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.annotation.RegistryType;

@Provider
@RestMetricsResponseFilteredNameBinding
public class RestMetricsResponseFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    @Inject
    @RegistryType(type=MetricRegistry.Type.APPLICATION)
    MetricRegistry metricRegistry;
    String REST_HTTP_REQUESTS_TOTAL = "rest_http_requests_total";
    String REST_HTTP_REQUESTS_TOTAL_DESC = "Total number of REST HTTP Requests";
    String REST_HTTP_REQUESTS_TIME = "rest_http_request_duration";
    String REST_HTTP_REQUESTS_TIME_DESC = "Execution time of REST HTTP Requests in seconds";
    private Clock clock = Clock.defaultClock();
    public static final String REQUEST_START_TIME_CONTEXT_PROPERTY_NAME = "request-start-time";
    @Context
    private ResourceInfo resourceInfo;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        long sample = this.clock.getTick();
        requestContext.setProperty(REQUEST_START_TIME_CONTEXT_PROPERTY_NAME, (Object)sample);
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        int statusCode = responseContext.getStatus();
        if (statusCode == -1) {
            return;
        }
        if (statusCode < 100 || statusCode >= 600) {
            return;
        }
        int statusFamilyCode = statusCode / 100;
        Metadata metadata = Metadata.builder().withName(this.REST_HTTP_REQUESTS_TOTAL).withDescription(this.REST_HTTP_REQUESTS_TOTAL_DESC).withType(MetricType.COUNTER).build();
        Tag[] counterTags = new Tag[]{new Tag("group", "REST"), new Tag("metric", this.REST_HTTP_REQUESTS_TOTAL), new Tag("status", String.format("%dxx", statusFamilyCode)), new Tag("endpoint", this.getUri()), new Tag("method", requestContext.getMethod())};
        Counter statusFamilyCounter = this.metricRegistry.counter(metadata, counterTags);
        statusFamilyCounter.inc();
        long startTimeSample = (Long)requestContext.getProperty(REQUEST_START_TIME_CONTEXT_PROPERTY_NAME);
        long endTimeSample = this.clock.getTick();
        long elapsed = endTimeSample - startTimeSample;
        Metadata timerMetadata = Metadata.builder().withName(this.REST_HTTP_REQUESTS_TIME).withDescription(this.REST_HTTP_REQUESTS_TIME_DESC).withType(MetricType.TIMER).build();
        Tag[] timerTags = new Tag[]{new Tag("group", "REST"), new Tag("metric", this.REST_HTTP_REQUESTS_TIME), new Tag("status", String.format("%dxx", statusFamilyCode)), new Tag("endpoint", this.getUri()), new Tag("method", requestContext.getMethod())};
        Timer timer = this.metricRegistry.timer(timerMetadata, timerTags);
        timer.update(elapsed, TimeUnit.NANOSECONDS);
    }

    private String getUri() {
        return this.getResourceClassPath() + this.getResourceMethodPath();
    }

    private String getResourceClassPath() {
        Path classPath = this.resourceInfo.getResourceClass().getAnnotation(Path.class);
        return classPath != null ? classPath.value() : "";
    }

    private String getResourceMethodPath() {
        Path methodPath = this.resourceInfo.getResourceMethod().getAnnotation(Path.class);
        return methodPath != null ? methodPath.value() : "";
    }
}

