/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.rules.RuleApplicationType;
import io.apicurio.registry.rules.RuleContext;
import io.apicurio.registry.rules.RuleExecutor;
import io.apicurio.registry.rules.RuleExecutorFactory;
import io.apicurio.registry.rules.RuleViolationException;
import io.apicurio.registry.rules.RulesProperties;
import io.apicurio.registry.rules.RulesService;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.RuleConfigurationDto;
import io.apicurio.registry.storage.StoredArtifact;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.types.RuleType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class RulesServiceImpl
implements RulesService {
    @Inject
    @Current
    RegistryStorage storage;
    @Inject
    RuleExecutorFactory factory;
    @Inject
    RulesProperties rulesProperties;

    @Override
    public void applyRules(String artifactId, ArtifactType artifactType, ContentHandle artifactContent, RuleApplicationType ruleApplicationType) throws RuleViolationException {
        List<RuleType> rules = Collections.EMPTY_LIST;
        if (ruleApplicationType == RuleApplicationType.UPDATE) {
            rules = this.storage.getArtifactRules(artifactId);
        }
        ContentHandle currentArtifactContent = null;
        if (ruleApplicationType == RuleApplicationType.UPDATE) {
            StoredArtifact currentArtifact = this.storage.getArtifact(artifactId);
            currentArtifactContent = currentArtifact.getContent();
        }
        this.applyGlobalAndArtifactRules(artifactId, artifactType, currentArtifactContent, artifactContent, rules);
    }

    private void applyGlobalAndArtifactRules(String artifactId, ArtifactType artifactType, ContentHandle currentArtifactContent, ContentHandle updatedArtifactContent, List<RuleType> artifactRules) {
        Map<RuleType, RuleConfigurationDto> globalOrArtifactRulesMap = artifactRules.stream().collect(Collectors.toMap(ruleType -> ruleType, ruleType -> this.storage.getArtifactRule(artifactId, (RuleType)ruleType)));
        if (globalOrArtifactRulesMap.isEmpty()) {
            List<RuleType> globalRules = this.storage.getGlobalRules();
            globalOrArtifactRulesMap = globalRules.stream().collect(Collectors.toMap(ruleType -> ruleType, this.storage::getGlobalRule));
            Map<RuleType, RuleConfigurationDto> filteredDefaultGlobalRulesMap = this.rulesProperties.getFilteredDefaultGlobalRules(globalRules).stream().collect(Collectors.toMap(ruleType -> ruleType, this.rulesProperties::getDefaultGlobalRuleConfiguration));
            globalOrArtifactRulesMap.putAll(filteredDefaultGlobalRulesMap);
        }
        if (globalOrArtifactRulesMap.isEmpty()) {
            return;
        }
        for (RuleType ruleType2 : globalOrArtifactRulesMap.keySet()) {
            this.applyRule(artifactId, artifactType, currentArtifactContent, updatedArtifactContent, ruleType2, globalOrArtifactRulesMap.get(ruleType2).getConfiguration());
        }
    }

    @Override
    public void applyRule(String artifactId, ArtifactType artifactType, ContentHandle artifactContent, RuleType ruleType, String ruleConfiguration, RuleApplicationType ruleApplicationType) throws RuleViolationException {
        ContentHandle currentArtifactContent = null;
        if (ruleApplicationType == RuleApplicationType.UPDATE) {
            StoredArtifact currentArtifact = this.storage.getArtifact(artifactId);
            currentArtifactContent = currentArtifact.getContent();
        }
        this.applyRule(artifactId, artifactType, currentArtifactContent, artifactContent, ruleType, ruleConfiguration);
    }

    private void applyRule(String artifactId, ArtifactType artifactType, ContentHandle currentContent, ContentHandle updatedContent, RuleType ruleType, String ruleConfiguration) {
        RuleExecutor executor = this.factory.createExecutor(ruleType);
        RuleContext context = new RuleContext(artifactId, artifactType, ruleConfiguration, currentContent, updatedContent);
        executor.execute(context);
    }

    @Override
    public void applyRules(String artifactId, long artifactVersion, ArtifactType artifactType, ContentHandle updatedContent) throws RuleViolationException {
        StoredArtifact versionContent = this.storage.getArtifactVersion(artifactId, artifactVersion);
        this.applyGlobalAndArtifactRules(artifactId, artifactType, versionContent.getContent(), updatedContent, this.storage.getArtifactRules(artifactId));
    }
}

