/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.compatibility;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import com.google.common.io.Files;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.internal.parser.EnumConstantElement;
import com.squareup.wire.schema.internal.parser.EnumElement;
import com.squareup.wire.schema.internal.parser.FieldElement;
import com.squareup.wire.schema.internal.parser.MessageElement;
import com.squareup.wire.schema.internal.parser.OneOfElement;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import com.squareup.wire.schema.internal.parser.ProtoParser;
import com.squareup.wire.schema.internal.parser.ReservedElement;
import com.squareup.wire.schema.internal.parser.RpcElement;
import com.squareup.wire.schema.internal.parser.ServiceElement;
import com.squareup.wire.schema.internal.parser.TypeElement;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProtobufFile {
    private final ProtoFileElement element;
    private final Map<String, Set<Object>> reservedFields = new HashMap<String, Set<Object>>();
    private final Map<String, Map<String, FieldElement>> fieldMap = new HashMap<String, Map<String, FieldElement>>();
    private final Map<String, Map<String, EnumConstantElement>> enumFieldMap = new HashMap<String, Map<String, EnumConstantElement>>();
    private final Map<String, Map<String, FieldElement>> mapMap = new HashMap<String, Map<String, FieldElement>>();
    private final Map<String, Set<Object>> nonReservedFields = new HashMap<String, Set<Object>>();
    private final Map<String, Set<Object>> nonReservedEnumFields = new HashMap<String, Set<Object>>();
    private final Map<String, Map<Integer, String>> fieldsById = new HashMap<String, Map<Integer, String>>();
    private final Map<String, Map<Integer, String>> enumFieldsById = new HashMap<String, Map<Integer, String>>();
    private final Map<String, Set<String>> serviceRPCnames = new HashMap<String, Set<String>>();
    private final Map<String, Map<String, String>> serviceRPCSignatures = new HashMap<String, Map<String, String>>();

    public ProtobufFile(String data) {
        this.element = ProtobufFile.toProtoFileElement(data);
        this.buildIndexes();
    }

    public ProtobufFile(File file) throws IOException {
        Location location = Location.get((String)file.getAbsolutePath());
        List data = Files.readLines((File)file, (Charset)StandardCharsets.UTF_8);
        this.element = ProtobufFile.toProtoFileElement(String.join((CharSequence)"\n", data));
        this.buildIndexes();
    }

    public static ProtoFileElement toProtoFileElement(String data) {
        ProtoParser parser = new ProtoParser(Location.get((String)""), data.toCharArray());
        return parser.readProtoFile();
    }

    public Map<String, Set<Object>> getReservedFields() {
        return this.reservedFields;
    }

    public Map<String, Map<String, FieldElement>> getFieldMap() {
        return this.fieldMap;
    }

    public Map<String, Map<String, EnumConstantElement>> getEnumFieldMap() {
        return this.enumFieldMap;
    }

    public Map<String, Map<String, FieldElement>> getMapMap() {
        return this.mapMap;
    }

    public Map<String, Set<Object>> getNonReservedFields() {
        return this.nonReservedFields;
    }

    public Map<String, Set<Object>> getNonReservedEnumFields() {
        return this.nonReservedEnumFields;
    }

    public Map<String, Map<Integer, String>> getFieldsById() {
        return this.fieldsById;
    }

    public Map<String, Map<Integer, String>> getEnumFieldsById() {
        return this.enumFieldsById;
    }

    public Map<String, Set<String>> getServiceRPCnames() {
        return this.serviceRPCnames;
    }

    public Map<String, Map<String, String>> getServiceRPCSignatures() {
        return this.serviceRPCSignatures;
    }

    private void buildIndexes() {
        for (TypeElement typeElement : this.element.getTypes()) {
            if (typeElement instanceof MessageElement) {
                MessageElement messageElement = (MessageElement)typeElement;
                this.processMessageElement("", messageElement);
                continue;
            }
            if (typeElement instanceof EnumElement) {
                EnumElement enumElement = (EnumElement)typeElement;
                this.processEnumElement("", enumElement);
                continue;
            }
            throw new RuntimeException();
        }
        for (ServiceElement serviceElement : this.element.getServices()) {
            HashSet<String> rpcNames = new HashSet<String>();
            HashMap<String, String> rpcSignatures = new HashMap<String, String>();
            for (RpcElement rpcElement : serviceElement.getRpcs()) {
                rpcNames.add(rpcElement.getName());
                String signature = rpcElement.getRequestType() + ":" + rpcElement.getRequestStreaming() + "->" + rpcElement.getResponseType() + ":" + rpcElement.getResponseStreaming();
                rpcSignatures.put(rpcElement.getName(), signature);
            }
            if (rpcNames.isEmpty()) continue;
            this.serviceRPCnames.put(serviceElement.getName(), rpcNames);
            this.serviceRPCSignatures.put(serviceElement.getName(), rpcSignatures);
        }
    }

    private void processMessageElement(String scope, MessageElement messageElement) {
        HashSet reservedFieldSet = new HashSet();
        for (ReservedElement reservedElement : messageElement.getReserveds()) {
            for (Object value : reservedElement.getValues()) {
                if (value instanceof Range) {
                    reservedFieldSet.addAll(ContiguousSet.create((Range)((Range)value), (DiscreteDomain)DiscreteDomain.integers()));
                    continue;
                }
                reservedFieldSet.add(value);
            }
        }
        if (!reservedFieldSet.isEmpty()) {
            this.reservedFields.put(scope + messageElement.getName(), reservedFieldSet);
        }
        HashMap<String, FieldElement> fieldTypeMap = new HashMap<String, FieldElement>();
        HashMap<String, FieldElement> mapMap = new HashMap<String, FieldElement>();
        HashMap<Integer, String> idsToNames = new HashMap<Integer, String>();
        for (FieldElement fieldElement : messageElement.getFields()) {
            fieldTypeMap.put(fieldElement.getName(), fieldElement);
            if (fieldElement.getType().startsWith("map<")) {
                mapMap.put(fieldElement.getName(), fieldElement);
            }
            idsToNames.put(fieldElement.getTag(), fieldElement.getName());
        }
        for (OneOfElement oneOfElement : messageElement.getOneOfs()) {
            for (FieldElement fieldElement : oneOfElement.getFields()) {
                fieldTypeMap.put(fieldElement.getName(), fieldElement);
                if (fieldElement.getType().startsWith("map<")) {
                    mapMap.put(fieldElement.getName(), fieldElement);
                }
                idsToNames.put(fieldElement.getTag(), fieldElement.getName());
            }
        }
        if (!fieldTypeMap.isEmpty()) {
            this.fieldMap.put(scope + messageElement.getName(), fieldTypeMap);
        }
        if (!mapMap.isEmpty()) {
            this.mapMap.put(scope + messageElement.getName(), mapMap);
        }
        if (!idsToNames.isEmpty()) {
            this.fieldsById.put(scope + messageElement.getName(), idsToNames);
        }
        HashSet<Object> fieldKeySet = new HashSet<Object>();
        for (FieldElement fieldElement : messageElement.getFields()) {
            fieldKeySet.add(fieldElement.getTag());
            fieldKeySet.add(fieldElement.getName());
        }
        for (OneOfElement oneOfElement : messageElement.getOneOfs()) {
            for (FieldElement fieldElement : oneOfElement.getFields()) {
                fieldKeySet.add(fieldElement.getTag());
                fieldKeySet.add(fieldElement.getName());
            }
        }
        if (!fieldKeySet.isEmpty()) {
            this.nonReservedFields.put(scope + messageElement.getName(), fieldKeySet);
        }
        for (TypeElement typeElement : messageElement.getNestedTypes()) {
            if (typeElement instanceof MessageElement) {
                this.processMessageElement(messageElement.getName() + ".", (MessageElement)typeElement);
                continue;
            }
            if (!(typeElement instanceof EnumElement)) continue;
            this.processEnumElement(messageElement.getName() + ".", (EnumElement)typeElement);
        }
    }

    private void processEnumElement(String scope, EnumElement enumElement) {
        HashMap<String, EnumConstantElement> map = new HashMap<String, EnumConstantElement>();
        HashMap<Integer, String> idsToNames = new HashMap<Integer, String>();
        HashSet<Object> fieldKeySet = new HashSet<Object>();
        for (EnumConstantElement enumConstantElement : enumElement.getConstants()) {
            map.put(enumConstantElement.getName(), enumConstantElement);
            idsToNames.put(enumConstantElement.getTag(), enumConstantElement.getName());
            fieldKeySet.add(enumConstantElement.getTag());
            fieldKeySet.add(enumConstantElement.getName());
        }
        if (!map.isEmpty()) {
            this.enumFieldMap.put(scope + enumElement.getName(), map);
        }
        if (!idsToNames.isEmpty()) {
            this.enumFieldsById.put(scope + enumElement.getName(), idsToNames);
        }
        if (!fieldKeySet.isEmpty()) {
            this.nonReservedEnumFields.put(scope + enumElement.getName(), fieldKeySet);
        }
    }
}

