/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.compatibility.jsonschema;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.apicurio.registry.rules.compatibility.jsonschema.JsonUtil;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.DiffContext;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.SchemaDiffVisitor;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.WrapUtil;
import org.everit.json.schema.Schema;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONObject;

public class JsonSchemaDiffLibrary {
    public static DiffContext findDifferences(String original, String updated) {
        try {
            JSONObject originalJson = (JSONObject)JsonUtil.MAPPER.readValue(original, JSONObject.class);
            JSONObject updatedJson = (JSONObject)JsonUtil.MAPPER.readValue(updated, JSONObject.class);
            Schema originalSchema = SchemaLoader.builder().schemaJson(originalJson).build().load().build();
            Schema updatedSchema = SchemaLoader.builder().schemaJson(updatedJson).build().load().build();
            return JsonSchemaDiffLibrary.findDifferences(originalSchema, updatedSchema);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static DiffContext findDifferences(Schema originalSchema, Schema updatedSchema) {
        DiffContext rootContext = DiffContext.createRootContext();
        new SchemaDiffVisitor(rootContext, originalSchema).visit(WrapUtil.wrap(updatedSchema));
        return rootContext;
    }

    public static boolean isCompatible(String original, String updated) {
        return JsonSchemaDiffLibrary.findDifferences(original, updated).foundAllDifferencesAreCompatible();
    }
}

