/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.validity;

import io.apicurio.registry.logging.Logged;
import io.apicurio.registry.rules.RuleContext;
import io.apicurio.registry.rules.RuleExecutor;
import io.apicurio.registry.rules.RuleViolationException;
import io.apicurio.registry.rules.validity.ContentValidator;
import io.apicurio.registry.rules.validity.InvalidContentException;
import io.apicurio.registry.rules.validity.ValidityLevel;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProviderFactory;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
@Logged
public class ValidityRuleExecutor
implements RuleExecutor {
    @Inject
    ArtifactTypeUtilProviderFactory factory;

    @Override
    public void execute(RuleContext context) throws RuleViolationException {
        try {
            ValidityLevel level = ValidityLevel.valueOf(context.getConfiguration());
            ArtifactTypeUtilProvider provider = this.factory.getArtifactTypeProvider(context.getArtifactType());
            ContentValidator validator = provider.getContentValidator();
            validator.validate(level, context.getUpdatedContent());
        }
        catch (InvalidContentException e) {
            throw new RuleViolationException(e.getMessage(), RuleType.VALIDITY, context.getConfiguration(), e);
        }
    }
}

