/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage;

import io.apicurio.registry.storage.NotFoundException;

public class ArtifactNotFoundException
extends NotFoundException {
    private static final long serialVersionUID = -3614783501078800654L;
    private String artifactId;

    public ArtifactNotFoundException(Throwable cause) {
        super(cause);
    }

    public ArtifactNotFoundException(String artifactId) {
        this.artifactId = artifactId;
    }

    public ArtifactNotFoundException(String artifactId, Throwable cause) {
        super("Artifact with ID '" + artifactId + "' not found.", cause);
        this.artifactId = artifactId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public String getMessage() {
        return "No artifact with ID '" + this.artifactId + "' was found.";
    }
}

