/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage;

import io.apicurio.registry.content.ContentHandle;

public final class StoredArtifact {
    private final Long id;
    private final Long version;
    private final ContentHandle content;

    public Long getGlobalId() {
        return this.id;
    }

    StoredArtifact(Long id, Long version, ContentHandle content) {
        this.id = id;
        this.version = version;
        this.content = content;
    }

    public static StoredArtifactBuilder builder() {
        return new StoredArtifactBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public Long getVersion() {
        return this.version;
    }

    public ContentHandle getContent() {
        return this.content;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StoredArtifact)) {
            return false;
        }
        StoredArtifact other = (StoredArtifact)o;
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        ContentHandle this$content = this.getContent();
        ContentHandle other$content = other.getContent();
        return !(this$content == null ? other$content != null : !this$content.equals(other$content));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        ContentHandle $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        return result;
    }

    public String toString() {
        return "StoredArtifact(id=" + this.getId() + ", version=" + this.getVersion() + ", content=" + this.getContent() + ")";
    }

    public static class StoredArtifactBuilder {
        private Long id;
        private Long version;
        private ContentHandle content;

        StoredArtifactBuilder() {
        }

        public StoredArtifactBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public StoredArtifactBuilder version(Long version) {
            this.version = version;
            return this;
        }

        public StoredArtifactBuilder content(ContentHandle content) {
            this.content = content;
            return this;
        }

        public StoredArtifact build() {
            return new StoredArtifact(this.id, this.version, this.content);
        }

        public String toString() {
            return "StoredArtifact.StoredArtifactBuilder(id=" + this.id + ", version=" + this.version + ", content=" + this.content + ")";
        }
    }
}

