/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.canon.ContentCanonicalizer;
import io.apicurio.registry.content.extract.ContentExtractor;
import io.apicurio.registry.rest.beans.ArtifactSearchResults;
import io.apicurio.registry.rest.beans.EditableMetaData;
import io.apicurio.registry.rest.beans.SearchOver;
import io.apicurio.registry.rest.beans.SortOrder;
import io.apicurio.registry.rest.beans.VersionSearchResults;
import io.apicurio.registry.storage.ArtifactAlreadyExistsException;
import io.apicurio.registry.storage.ArtifactMetaDataDto;
import io.apicurio.registry.storage.ArtifactNotFoundException;
import io.apicurio.registry.storage.ArtifactStateExt;
import io.apicurio.registry.storage.ArtifactVersionMetaDataDto;
import io.apicurio.registry.storage.EditableArtifactMetaDataDto;
import io.apicurio.registry.storage.InvalidPropertiesException;
import io.apicurio.registry.storage.MetaDataKeys;
import io.apicurio.registry.storage.RegistryStorageException;
import io.apicurio.registry.storage.RuleAlreadyExistsException;
import io.apicurio.registry.storage.RuleConfigurationDto;
import io.apicurio.registry.storage.RuleNotFoundException;
import io.apicurio.registry.storage.StoredArtifact;
import io.apicurio.registry.storage.VersionNotFoundException;
import io.apicurio.registry.storage.impl.AbstractRegistryStorage;
import io.apicurio.registry.storage.impl.MultiMap;
import io.apicurio.registry.storage.impl.StorageMap;
import io.apicurio.registry.storage.impl.TupleId;
import io.apicurio.registry.types.ArtifactState;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProviderFactory;
import io.apicurio.registry.util.DtoUtil;
import io.apicurio.registry.util.SearchUtil;
import io.apicurio.registry.utils.StringUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMapRegistryStorage
extends AbstractRegistryStorage {
    private static final int ARTIFACT_FIRST_VERSION = 1;
    @Inject
    protected ArtifactTypeUtilProviderFactory factory;
    protected StorageMap storage;
    protected Map<Long, TupleId> global;
    protected MultiMap<String, String, String> artifactRules;
    protected Map<String, String> globalRules;

    protected void beforeInit() {
    }

    @PostConstruct
    public void init() {
        this.beforeInit();
        this.storage = this.createStorageMap();
        this.global = this.createGlobalMap();
        this.globalRules = this.createGlobalRulesMap();
        this.artifactRules = this.createArtifactRulesMap();
        this.afterInit();
    }

    protected void afterInit() {
    }

    protected abstract long nextGlobalId();

    protected abstract StorageMap createStorageMap();

    protected abstract Map<Long, TupleId> createGlobalMap();

    protected abstract Map<String, String> createGlobalRulesMap();

    protected abstract MultiMap<String, String, String> createArtifactRulesMap();

    private Map<Long, Map<String, String>> getVersion2ContentMap(String artifactId) throws ArtifactNotFoundException {
        Map<Long, Map<String, String>> v2c = this.storage.get(artifactId);
        if (v2c == null || v2c.isEmpty()) {
            throw new ArtifactNotFoundException(artifactId);
        }
        return Collections.unmodifiableMap(v2c);
    }

    private Map<String, String> getContentMap(String artifactId, Long version, EnumSet<ArtifactState> states) throws ArtifactNotFoundException {
        Map<Long, Map<String, String>> v2c = this.getVersion2ContentMap(artifactId);
        Map<String, String> content = v2c.get(version);
        if (content == null) {
            throw new VersionNotFoundException(artifactId, version);
        }
        ArtifactState state = ArtifactStateExt.getState(content);
        ArtifactStateExt.validateState(states, state, artifactId, version);
        return Collections.unmodifiableMap(content);
    }

    public static Predicate<Map.Entry<Long, Map<String, String>>> statesFilter(EnumSet<ArtifactState> states) {
        return e -> states.contains(ArtifactStateExt.getState((Map)e.getValue()));
    }

    private Map<String, String> getLatestContentMap(String artifactId, EnumSet<ArtifactState> states) throws ArtifactNotFoundException, RegistryStorageException {
        Map<Long, Map<String, String>> v2c = this.getVersion2ContentMap(artifactId);
        Stream<Object> stream = v2c.entrySet().stream();
        if (states != null) {
            stream = stream.filter(AbstractMapRegistryStorage.statesFilter(states));
        }
        Map latest = (Map)((Map.Entry)stream.max((e1, e2) -> (int)((Long)e1.getKey() - (Long)e2.getKey())).orElseThrow(() -> new ArtifactNotFoundException(artifactId))).getValue();
        ArtifactStateExt.logIfDeprecated(artifactId, ArtifactStateExt.getState(latest), latest.get(MetaDataKeys.VERSION));
        return Collections.unmodifiableMap(latest);
    }

    private boolean filterSearchResult(String search, String artifactId, SearchOver searchOver) {
        if (search == null || search.trim().isEmpty()) {
            return true;
        }
        try {
            switch (searchOver) {
                case name: {
                    return this.valueContainsSearch(search, artifactId, searchOver.name()) || this.valueContainsSearch(search, artifactId, MetaDataKeys.ARTIFACT_ID);
                }
                case description: 
                case labels: {
                    return this.valueContainsSearch(search, artifactId, searchOver.name());
                }
            }
            return this.getLatestContentMap(artifactId, ArtifactStateExt.ACTIVE_STATES).values().stream().anyMatch(v -> v != null && StringUtils.containsIgnoreCase((CharSequence)v, (CharSequence)search));
        }
        catch (ArtifactNotFoundException notFound) {
            return false;
        }
    }

    private boolean valueContainsSearch(String search, String artifactId, String metaDataKey) {
        String value = this.getLatestContentMap(artifactId, ArtifactStateExt.ACTIVE_STATES).get(metaDataKey);
        return value != null && StringUtils.containsIgnoreCase((CharSequence)value, (CharSequence)search.toLowerCase());
    }

    @Nullable
    private ArtifactMetaDataDto getArtifactMetadataOrNull(String artifactId) {
        try {
            return this.getArtifactMetaData(artifactId);
        }
        catch (ArtifactNotFoundException ex) {
            return null;
        }
    }

    public static StoredArtifact toStoredArtifact(Map<String, String> content) {
        return StoredArtifact.builder().content(ContentHandle.create(MetaDataKeys.getContent(content))).version(Long.parseLong(content.get(MetaDataKeys.VERSION))).id(Long.parseLong(content.get(MetaDataKeys.GLOBAL_ID))).build();
    }

    protected BiFunction<String, Map<Long, Map<String, String>>, Map<Long, Map<String, String>>> lookupFn() {
        return (id, m) -> m == null ? new ConcurrentHashMap() : m;
    }

    protected ArtifactMetaDataDto createOrUpdateArtifact(String artifactId, ArtifactType artifactType, ContentHandle content, boolean create, long globalId) throws ArtifactAlreadyExistsException, ArtifactNotFoundException, RegistryStorageException {
        EditableMetaData emd;
        ArtifactTypeUtilProvider provider;
        ContentExtractor extractor;
        Map<String, String> prevContents;
        if (artifactId == null) {
            if (!create) {
                throw new ArtifactNotFoundException("Null artifactId!");
            }
            artifactId = UUID.randomUUID().toString();
        }
        Map<Long, Map<String, String>> v2c = this.storage.compute(artifactId);
        if (create && v2c.size() > 0) {
            throw new ArtifactAlreadyExistsException(artifactId);
        }
        if (!create && v2c.size() == 0) {
            this.storage.remove(artifactId);
            throw new ArtifactNotFoundException(artifactId);
        }
        long version = v2c.keySet().stream().max(Long::compareTo).orElse(0L) + 1L;
        long prevVersion = version - 1L;
        ConcurrentHashMap<String, String> contents = new ConcurrentHashMap<String, String>();
        MetaDataKeys.putContent(contents, content.bytes());
        contents.put(MetaDataKeys.VERSION, Long.toString(version));
        contents.put(MetaDataKeys.GLOBAL_ID, String.valueOf(globalId));
        contents.put(MetaDataKeys.ARTIFACT_ID, artifactId);
        String currentTimeMillis = String.valueOf(System.currentTimeMillis());
        contents.put(MetaDataKeys.CREATED_ON, currentTimeMillis);
        contents.put(MetaDataKeys.MODIFIED_ON, currentTimeMillis);
        contents.put(MetaDataKeys.TYPE, artifactType.value());
        ArtifactStateExt.applyState(contents, ArtifactState.ENABLED);
        if (!create && (prevContents = v2c.get(prevVersion)) != null) {
            if (prevContents.containsKey(MetaDataKeys.NAME)) {
                contents.put(MetaDataKeys.NAME, prevContents.get(MetaDataKeys.NAME));
            }
            if (prevContents.containsKey(MetaDataKeys.DESCRIPTION)) {
                contents.put(MetaDataKeys.DESCRIPTION, prevContents.get(MetaDataKeys.DESCRIPTION));
            }
        }
        if ((extractor = (provider = this.factory.getArtifactTypeProvider(artifactType)).getContentExtractor()).isExtracted(emd = extractor.extract(content))) {
            if (!StringUtil.isEmpty((String)emd.getName())) {
                contents.put(MetaDataKeys.NAME, emd.getName());
            }
            if (!StringUtil.isEmpty((String)emd.getDescription())) {
                contents.put(MetaDataKeys.DESCRIPTION, emd.getDescription());
            }
        }
        this.storage.createVersion(artifactId, version, contents);
        this.global.put(globalId, new TupleId(artifactId, version));
        ArtifactMetaDataDto artifactMetaDataDto = MetaDataKeys.toArtifactMetaData(contents);
        if (artifactMetaDataDto.getVersion() != 1) {
            ArtifactVersionMetaDataDto firstVersionContent = this.getArtifactVersionMetaData(artifactId, 1L);
            artifactMetaDataDto.setCreatedOn(firstVersionContent.getCreatedOn());
        }
        return artifactMetaDataDto;
    }

    protected Map<String, String> getContentMap(long id) {
        TupleId mapping = this.global.get(id);
        if (mapping == null) {
            throw new ArtifactNotFoundException(String.valueOf(id));
        }
        Map<String, String> content = this.getContentMap(mapping.getId(), mapping.getVersion(), ArtifactStateExt.ACTIVE_STATES);
        if (content == null) {
            throw new ArtifactNotFoundException(String.valueOf(id));
        }
        ArtifactStateExt.logIfDeprecated(id, ArtifactStateExt.getState(content), content.get(MetaDataKeys.VERSION));
        return content;
    }

    @Override
    public void updateArtifactState(String artifactId, ArtifactState state) {
        this.updateArtifactState(artifactId, state, null);
    }

    @Override
    public void updateArtifactState(String artifactId, ArtifactState state, Integer version) {
        Map<String, String> content = null;
        if (version == null) {
            content = this.getLatestContentMap(artifactId, null);
            version = Integer.parseInt(content.get(MetaDataKeys.VERSION));
        }
        int fVersion = version;
        if (state == ArtifactState.DELETED) {
            this.deleteArtifactVersionInternal(artifactId, version.intValue());
        } else {
            if (content == null) {
                content = this.getContentMap(artifactId, version.longValue(), null);
            }
            ArtifactStateExt.applyState(s -> this.storage.put(artifactId, fVersion, MetaDataKeys.STATE, s.name()), content, state);
        }
    }

    @Override
    public CompletionStage<ArtifactMetaDataDto> createArtifact(String artifactId, ArtifactType artifactType, ContentHandle content) throws ArtifactAlreadyExistsException, RegistryStorageException {
        try {
            ArtifactMetaDataDto amdd = this.createOrUpdateArtifact(artifactId, artifactType, content, true, this.nextGlobalId());
            return CompletableFuture.completedFuture(amdd);
        }
        catch (ArtifactNotFoundException e) {
            throw new RegistryStorageException("Invalid state", e);
        }
    }

    @Override
    public CompletionStage<ArtifactMetaDataDto> createArtifactWithMetadata(String artifactId, ArtifactType artifactType, ContentHandle content, EditableArtifactMetaDataDto metadata) throws ArtifactAlreadyExistsException, RegistryStorageException {
        try {
            ArtifactMetaDataDto amdd = this.createOrUpdateArtifact(artifactId, artifactType, content, true, this.nextGlobalId());
            this.updateArtifactMetaData(artifactId, metadata);
            DtoUtil.setEditableMetaDataInArtifact(amdd, metadata);
            return CompletableFuture.completedFuture(amdd);
        }
        catch (ArtifactNotFoundException e) {
            throw new RegistryStorageException("Invalid state", e);
        }
    }

    @Override
    public SortedSet<Long> deleteArtifact(String artifactId) throws ArtifactNotFoundException, RegistryStorageException {
        Map<Long, Map<String, String>> v2c = this.storage.remove(artifactId);
        if (v2c == null) {
            throw new ArtifactNotFoundException(artifactId);
        }
        v2c.values().forEach(m -> {
            long globalId = Long.parseLong((String)m.get(MetaDataKeys.GLOBAL_ID));
            this.global.remove(globalId);
        });
        this.deleteArtifactRulesInternal(artifactId);
        return new TreeSet<Long>(v2c.keySet());
    }

    @Override
    public StoredArtifact getArtifact(String artifactId) throws ArtifactNotFoundException, RegistryStorageException {
        return AbstractMapRegistryStorage.toStoredArtifact(this.getLatestContentMap(artifactId, ArtifactStateExt.ACTIVE_STATES));
    }

    @Override
    public CompletionStage<ArtifactMetaDataDto> updateArtifact(String artifactId, ArtifactType artifactType, ContentHandle content) throws ArtifactNotFoundException, RegistryStorageException {
        try {
            ArtifactMetaDataDto amdd = this.createOrUpdateArtifact(artifactId, artifactType, content, false, this.nextGlobalId());
            return CompletableFuture.completedFuture(amdd);
        }
        catch (ArtifactAlreadyExistsException e) {
            throw new RegistryStorageException("Invalid state", e);
        }
    }

    @Override
    public CompletionStage<ArtifactMetaDataDto> updateArtifactWithMetadata(String artifactId, ArtifactType artifactType, ContentHandle content, EditableArtifactMetaDataDto metadata) throws ArtifactNotFoundException, RegistryStorageException {
        try {
            ArtifactMetaDataDto amdd = this.createOrUpdateArtifact(artifactId, artifactType, content, false, this.nextGlobalId());
            this.updateArtifactMetaData(artifactId, metadata);
            DtoUtil.setEditableMetaDataInArtifact(amdd, metadata);
            return CompletableFuture.completedFuture(amdd);
        }
        catch (ArtifactAlreadyExistsException e) {
            throw new RegistryStorageException("Invalid state", e);
        }
    }

    @Override
    public Set<String> getArtifactIds(Integer limit) {
        if (limit != null) {
            return this.storage.keySet().stream().limit(limit.intValue()).collect(Collectors.toSet());
        }
        return this.storage.keySet();
    }

    @Override
    public ArtifactSearchResults searchArtifacts(String search, int offset, int limit, SearchOver over, SortOrder order) {
        LongAdder itemsCount = new LongAdder();
        List matchedArtifacts = this.getArtifactIds(null).stream().filter(artifactId -> this.filterSearchResult(search, (String)artifactId, over)).map(this::getArtifactMetadataOrNull).filter(Objects::nonNull).peek(artifactId -> itemsCount.increment()).sorted(SearchUtil.comparator(order)).skip(offset).limit(limit).map(SearchUtil::buildSearchedArtifact).collect(Collectors.toList());
        ArtifactSearchResults artifactSearchResults = new ArtifactSearchResults();
        artifactSearchResults.setArtifacts(matchedArtifacts);
        artifactSearchResults.setCount(Integer.valueOf(itemsCount.intValue()));
        return artifactSearchResults;
    }

    @Override
    public ArtifactMetaDataDto getArtifactMetaData(String artifactId) throws ArtifactNotFoundException, RegistryStorageException {
        Map<String, String> content = this.getLatestContentMap(artifactId, ArtifactStateExt.ACTIVE_STATES);
        ArtifactMetaDataDto artifactMetaDataDto = MetaDataKeys.toArtifactMetaData(content);
        if (artifactMetaDataDto.getVersion() != 1) {
            ArtifactVersionMetaDataDto firstVersionContent = this.getArtifactVersionMetaData(artifactId, 1L);
            artifactMetaDataDto.setCreatedOn(firstVersionContent.getCreatedOn());
        }
        SortedSet<Long> versions = this.getArtifactVersions(artifactId);
        if ((long)artifactMetaDataDto.getVersion() != versions.last()) {
            ArtifactVersionMetaDataDto artifactVersionMetaDataDto = this.getArtifactVersionMetaData(artifactId, versions.last());
            artifactMetaDataDto.setModifiedOn(artifactVersionMetaDataDto.getCreatedOn());
        }
        return artifactMetaDataDto;
    }

    @Override
    public ArtifactMetaDataDto getArtifactMetaData(String artifactId, ContentHandle content) throws ArtifactNotFoundException, RegistryStorageException {
        ArtifactMetaDataDto metaData = this.getArtifactMetaData(artifactId);
        ArtifactTypeUtilProvider provider = this.factory.getArtifactTypeProvider(metaData.getType());
        ContentCanonicalizer canonicalizer = provider.getContentCanonicalizer();
        ContentHandle canonicalContent = canonicalizer.canonicalize(content);
        byte[] canonicalBytes = canonicalContent.bytes();
        Map<Long, Map<String, String>> map = this.getVersion2ContentMap(artifactId);
        for (Map<String, String> cMap : map.values()) {
            ContentHandle candidateContent = ContentHandle.create(MetaDataKeys.getContent(cMap));
            ContentHandle canonicalCandidateContent = canonicalizer.canonicalize(candidateContent);
            byte[] candidateBytes = canonicalCandidateContent.bytes();
            if (!Arrays.equals(canonicalBytes, candidateBytes)) continue;
            ArtifactStateExt.logIfDeprecated(artifactId, ArtifactStateExt.getState(cMap), cMap.get(MetaDataKeys.VERSION));
            ArtifactMetaDataDto artifactMetaDataDto = MetaDataKeys.toArtifactMetaData(cMap);
            artifactMetaDataDto.setCreatedOn(metaData.getCreatedOn());
            artifactMetaDataDto.setModifiedOn(metaData.getModifiedOn());
            return artifactMetaDataDto;
        }
        throw new ArtifactNotFoundException(artifactId);
    }

    @Override
    public ArtifactMetaDataDto getArtifactMetaData(long id) throws ArtifactNotFoundException, RegistryStorageException {
        Map<String, String> content = this.getContentMap(id);
        return MetaDataKeys.toArtifactMetaData(content);
    }

    @Override
    public void updateArtifactMetaData(String artifactId, EditableArtifactMetaDataDto metaData) throws ArtifactNotFoundException, RegistryStorageException, InvalidPropertiesException {
        if (metaData.getName() != null) {
            this.storage.put(artifactId, MetaDataKeys.NAME, metaData.getName());
        }
        if (metaData.getDescription() != null) {
            this.storage.put(artifactId, MetaDataKeys.DESCRIPTION, metaData.getDescription());
        }
        if (metaData.getLabels() != null && !metaData.getLabels().isEmpty()) {
            this.storage.put(artifactId, MetaDataKeys.LABELS, String.join((CharSequence)",", metaData.getLabels()));
        }
        if (metaData.getProperties() != null && !metaData.getProperties().isEmpty()) {
            try {
                this.storage.put(artifactId, MetaDataKeys.PROPERTIES, new ObjectMapper().writeValueAsString(metaData.getProperties()));
            }
            catch (JsonProcessingException e) {
                throw new InvalidPropertiesException(MetaDataKeys.PROPERTIES + " could not be processed for storage.", e);
            }
        }
    }

    @Override
    public List<RuleType> getArtifactRules(String artifactId) throws ArtifactNotFoundException, RegistryStorageException {
        this.getVersion2ContentMap(artifactId);
        Set<String> arules = this.artifactRules.keys(artifactId);
        return arules.stream().map(RuleType::fromValue).collect(Collectors.toList());
    }

    @Override
    public CompletionStage<Void> createArtifactRuleAsync(String artifactId, RuleType rule, RuleConfigurationDto config) throws ArtifactNotFoundException, RuleAlreadyExistsException, RegistryStorageException {
        this.getVersion2ContentMap(artifactId);
        String cdata = config.getConfiguration();
        String prevValue = this.artifactRules.putIfAbsent(artifactId, rule.name(), cdata == null ? "" : cdata);
        if (prevValue != null) {
            throw new RuleAlreadyExistsException(rule);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public void deleteArtifactRules(String artifactId) throws ArtifactNotFoundException, RegistryStorageException {
        this.getVersion2ContentMap(artifactId);
        this.deleteArtifactRulesInternal(artifactId);
    }

    protected void deleteArtifactRulesInternal(String artifactId) throws RegistryStorageException {
        this.artifactRules.remove(artifactId);
    }

    @Override
    public RuleConfigurationDto getArtifactRule(String artifactId, RuleType rule) throws ArtifactNotFoundException, RuleNotFoundException, RegistryStorageException {
        this.getVersion2ContentMap(artifactId);
        String config = this.artifactRules.get(artifactId, rule.name());
        if (config == null) {
            throw new RuleNotFoundException(rule);
        }
        return new RuleConfigurationDto(config);
    }

    @Override
    public void updateArtifactRule(String artifactId, RuleType rule, RuleConfigurationDto config) throws ArtifactNotFoundException, RuleNotFoundException, RegistryStorageException {
        this.getVersion2ContentMap(artifactId);
        String cdata = config.getConfiguration();
        String prevValue = this.artifactRules.putIfPresent(artifactId, rule.name(), cdata == null ? "" : cdata);
        if (prevValue == null) {
            throw new RuleNotFoundException(rule);
        }
    }

    @Override
    public void deleteArtifactRule(String artifactId, RuleType rule) throws ArtifactNotFoundException, RuleNotFoundException, RegistryStorageException {
        this.getVersion2ContentMap(artifactId);
        String prevValue = this.artifactRules.remove(artifactId, rule.name());
        if (prevValue == null) {
            throw new RuleNotFoundException(rule);
        }
    }

    @Override
    public SortedSet<Long> getArtifactVersions(String artifactId) throws ArtifactNotFoundException, RegistryStorageException {
        Map<Long, Map<String, String>> v2c = this.getVersion2ContentMap(artifactId);
        return new TreeSet<Long>(v2c.keySet());
    }

    @Override
    public VersionSearchResults searchVersions(String artifactId, int offset, int limit) throws ArtifactNotFoundException, RegistryStorageException {
        VersionSearchResults versionSearchResults = new VersionSearchResults();
        Map<Long, Map<String, String>> v2c = this.getVersion2ContentMap(artifactId);
        LongAdder itemsCount = new LongAdder();
        List artifactVersions = v2c.keySet().stream().peek(version -> itemsCount.increment()).sorted(Long::compareTo).skip(offset).limit(limit).map(version -> MetaDataKeys.toArtifactVersionMetaData((Map)v2c.get(version))).map(SearchUtil::buildSearchedVersion).collect(Collectors.toList());
        versionSearchResults.setVersions(artifactVersions);
        versionSearchResults.setCount(Integer.valueOf(itemsCount.intValue()));
        return versionSearchResults;
    }

    @Override
    public StoredArtifact getArtifactVersion(long id) throws ArtifactNotFoundException, RegistryStorageException {
        Map<String, String> content = this.getContentMap(id);
        return AbstractMapRegistryStorage.toStoredArtifact(content);
    }

    @Override
    public StoredArtifact getArtifactVersion(String artifactId, long version) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException {
        Map<String, String> content = this.getContentMap(artifactId, version, ArtifactStateExt.ACTIVE_STATES);
        return AbstractMapRegistryStorage.toStoredArtifact(content);
    }

    @Override
    public void deleteArtifactVersion(String artifactId, long version) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException {
        this.deleteArtifactVersionInternal(artifactId, version);
    }

    private void deleteArtifactVersionInternal(String artifactId, long version) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException {
        Long globalId = this.storage.remove(artifactId, version);
        if (globalId == null) {
            throw new VersionNotFoundException(artifactId, version);
        }
        this.global.remove(globalId);
    }

    @Override
    public ArtifactVersionMetaDataDto getArtifactVersionMetaData(String artifactId, long version) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException {
        Map<String, String> content = this.getContentMap(artifactId, version, null);
        return MetaDataKeys.toArtifactVersionMetaData(content);
    }

    @Override
    public void updateArtifactVersionMetaData(String artifactId, long version, EditableArtifactMetaDataDto metaData) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException {
        if (metaData.getName() != null) {
            this.storage.put(artifactId, version, MetaDataKeys.NAME, metaData.getName());
        }
        if (metaData.getDescription() != null) {
            this.storage.put(artifactId, version, MetaDataKeys.DESCRIPTION, metaData.getDescription());
        }
    }

    @Override
    public void deleteArtifactVersionMetaData(String artifactId, long version) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException {
        this.storage.remove(artifactId, version, MetaDataKeys.NAME);
        this.storage.remove(artifactId, version, MetaDataKeys.DESCRIPTION);
    }

    @Override
    public List<RuleType> getGlobalRules() throws RegistryStorageException {
        return this.globalRules.keySet().stream().map(RuleType::fromValue).collect(Collectors.toList());
    }

    @Override
    public void createGlobalRule(RuleType rule, RuleConfigurationDto config) throws RuleAlreadyExistsException, RegistryStorageException {
        String cdata = config.getConfiguration();
        String prevValue = this.globalRules.putIfAbsent(rule.name(), cdata == null ? "" : cdata);
        if (prevValue != null) {
            throw new RuleAlreadyExistsException(rule);
        }
    }

    @Override
    public void deleteGlobalRules() throws RegistryStorageException {
        this.globalRules.clear();
    }

    @Override
    public RuleConfigurationDto getGlobalRule(RuleType rule) throws RuleNotFoundException, RegistryStorageException {
        String cdata = this.globalRules.get(rule.name());
        if (cdata == null) {
            throw new RuleNotFoundException(rule);
        }
        return new RuleConfigurationDto(cdata);
    }

    @Override
    public void updateGlobalRule(RuleType rule, RuleConfigurationDto config) throws RuleNotFoundException, RegistryStorageException {
        String rname = rule.name();
        if (!this.globalRules.containsKey(rname)) {
            throw new RuleNotFoundException(rule);
        }
        String cdata = config.getConfiguration();
        this.globalRules.put(rname, cdata == null ? "" : cdata);
    }

    @Override
    public void deleteGlobalRule(RuleType rule) throws RuleNotFoundException, RegistryStorageException {
        String prevValue = this.globalRules.remove(rule.name());
        if (prevValue == null) {
            throw new RuleNotFoundException(rule);
        }
    }
}

