/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl;

import io.apicurio.registry.logging.Logged;
import io.apicurio.registry.metrics.PersistenceExceptionLivenessApply;
import io.apicurio.registry.metrics.PersistenceTimeoutReadinessApply;
import io.apicurio.registry.storage.impl.SimpleMapRegistryStorage;
import java.util.concurrent.atomic.AtomicLong;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.metrics.annotation.ConcurrentGauge;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Timed;

@ApplicationScoped
@PersistenceExceptionLivenessApply
@PersistenceTimeoutReadinessApply
@Counted(name="storage_operation_count_InMemoryRegistryStorage", description="Total number of storage operations.", tags={"group=STORAGE", "metric=storage_operation_count"}, reusable=true)
@ConcurrentGauge(name="concurrent_operation_count_InMemoryRegistryStorage", description="Number of concurrent storage operations.", tags={"group=STORAGE", "metric=concurrent_operation_count"}, reusable=true)
@Timed(name="storage_operation_time_InMemoryRegistryStorage", description="Time for a storage operation to process.", tags={"group=STORAGE", "metric=storage_operation_time"}, unit="milliseconds", reusable=true)
@Logged
public class InMemoryRegistryStorage
extends SimpleMapRegistryStorage {
    private AtomicLong counter = new AtomicLong(1L);

    @Override
    protected long nextGlobalId() {
        return this.counter.getAndIncrement();
    }
}

