/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ccompat.rest.impl;

import io.apicurio.registry.ccompat.dto.SchemaContent;
import io.apicurio.registry.ccompat.dto.SubjectVersion;
import io.apicurio.registry.ccompat.rest.SchemasResource;
import io.apicurio.registry.ccompat.rest.impl.AbstractResource;
import io.apicurio.registry.logging.Logged;
import io.apicurio.registry.metrics.ResponseErrorLivenessCheck;
import io.apicurio.registry.metrics.ResponseTimeoutReadinessCheck;
import io.apicurio.registry.metrics.RestMetricsApply;
import io.apicurio.registry.types.ArtifactType;
import java.util.Arrays;
import java.util.List;
import javax.interceptor.Interceptors;
import org.eclipse.microprofile.metrics.annotation.ConcurrentGauge;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Timed;

@Interceptors(value={ResponseErrorLivenessCheck.class, ResponseTimeoutReadinessCheck.class})
@RestMetricsApply
@Counted(name="rest_request_count", description="Total number of REST requests.", tags={"group=REST", "metric=rest_request_count"})
@ConcurrentGauge(name="concurrent_request_count", description="Number of concurrent REST requests.", tags={"group=REST", "metric=concurrent_request_count"})
@Timed(name="rest_response_time", description="Time of a request-response interval.", tags={"group=REST", "metric=rest_response_time"}, unit="milliseconds")
@Logged
public class SchemasResourceImpl
extends AbstractResource
implements SchemasResource {
    @Override
    public SchemaContent getSchema(int id) {
        return this.facade.getSchemaContent(id);
    }

    @Override
    public List<SubjectVersion> getSubjectVersions(int id) {
        return this.facade.getSubjectVersions(id);
    }

    @Override
    public List<String> getRegisteredTypes() {
        return Arrays.asList(ArtifactType.JSON.value(), ArtifactType.PROTOBUF.value(), ArtifactType.AVRO.value());
    }
}

