/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ccompat.rest.impl;

import io.apicurio.registry.ccompat.dto.Schema;
import io.apicurio.registry.ccompat.dto.SchemaId;
import io.apicurio.registry.ccompat.dto.SchemaInfo;
import io.apicurio.registry.ccompat.rest.SubjectVersionsResource;
import io.apicurio.registry.ccompat.rest.impl.AbstractResource;
import io.apicurio.registry.ccompat.store.FacadeConverter;
import io.apicurio.registry.logging.Logged;
import io.apicurio.registry.metrics.ResponseErrorLivenessCheck;
import io.apicurio.registry.metrics.ResponseTimeoutReadinessCheck;
import io.apicurio.registry.metrics.RestMetricsApply;
import java.util.List;
import javax.interceptor.Interceptors;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.container.AsyncResponse;
import org.eclipse.microprofile.metrics.annotation.ConcurrentGauge;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Timed;

@Interceptors(value={ResponseErrorLivenessCheck.class, ResponseTimeoutReadinessCheck.class})
@RestMetricsApply
@Counted(name="rest_request_count", description="Total number of REST requests.", tags={"group=REST", "metric=rest_request_count"})
@ConcurrentGauge(name="concurrent_request_count", description="Number of concurrent REST requests.", tags={"group=REST", "metric=concurrent_request_count"})
@Timed(name="rest_response_time", description="Time of a request-response interval.", tags={"group=REST", "metric=rest_response_time"}, unit="milliseconds")
@Logged
public class SubjectVersionsResourceImpl
extends AbstractResource
implements SubjectVersionsResource {
    @Override
    public List<Integer> listVersions(String subject) throws Exception {
        return this.facade.getVersions(subject);
    }

    @Override
    public void register(AsyncResponse response, String subject, SchemaInfo request) throws Exception {
        this.facade.createSchema(subject, request.getSchema(), request.getSchemaType()).thenApply(FacadeConverter::convertUnsigned).whenComplete((id, t) -> {
            if (t != null) {
                response.resume(t);
            } else {
                response.resume((Object)new SchemaId((int)id));
            }
        });
    }

    @Override
    public Schema getSchemaByVersion(String subject, String version) throws Exception {
        return this.facade.getSchema(subject, version);
    }

    @Override
    public int deleteSchemaVersion(String subject, String version) throws Exception {
        try {
            return this.facade.deleteSchema(subject, version);
        }
        catch (IllegalArgumentException ex) {
            throw new BadRequestException((Throwable)ex);
        }
    }

    @Override
    public String getSchemaOnly(String subject, String version) throws Exception {
        return this.facade.getSchema(subject, version).getSchema();
    }

    @Override
    public List<Integer> getSchemasReferencedBy(String subject, Integer version) throws Exception {
        return this.facade.getVersions(subject);
    }
}

