/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ccompat.store;

import io.apicurio.registry.ccompat.dto.Schema;
import io.apicurio.registry.ccompat.dto.SchemaContent;
import io.apicurio.registry.ccompat.dto.SubjectVersion;
import io.apicurio.registry.storage.StoredArtifact;

public class FacadeConverter {
    public static int convertUnsigned(long value) {
        if (value < 0L || value > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Value out of unsigned integer range: " + value);
        }
        return (int)value;
    }

    public static Schema convert(String subject, StoredArtifact storedArtifact) {
        return new Schema(FacadeConverter.convertUnsigned(storedArtifact.getGlobalId()), subject, FacadeConverter.convertUnsigned(storedArtifact.getVersion().intValue()), storedArtifact.getContent().content());
    }

    public static SchemaContent convert(StoredArtifact artifactVersion) {
        return new SchemaContent(artifactVersion.getContent().content());
    }

    public static SubjectVersion convert(String artifactId, Long version) {
        return new SubjectVersion(artifactId, version);
    }
}

