/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ibmcompat.api;

import io.apicurio.registry.ibmcompat.api.ApiService;
import io.apicurio.registry.ibmcompat.api.impl.ApiUtil;
import io.apicurio.registry.ibmcompat.model.NewSchema;
import io.apicurio.registry.ibmcompat.model.NewSchemaVersion;
import io.apicurio.registry.ibmcompat.model.Schema;
import io.apicurio.registry.ibmcompat.model.SchemaInfo;
import io.apicurio.registry.ibmcompat.model.SchemaListItem;
import io.apicurio.registry.ibmcompat.model.SchemaModificationPatch;
import io.apicurio.registry.metrics.RestMetricsApply;
import io.apicurio.registry.storage.ArtifactAlreadyExistsException;
import io.apicurio.registry.storage.ArtifactNotFoundException;
import java.util.List;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.eclipse.microprofile.metrics.annotation.ConcurrentGauge;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Timed;

@Path(value="/ibmcompat")
@RestMetricsApply
@Counted(name="rest_request_count", description="Total number of REST requests.", tags={"group=REST", "metric=rest_request_count"})
@ConcurrentGauge(name="concurrent_request_count", description="Number of concurrent REST requests.", tags={"group=REST", "metric=concurrent_request_count"})
@Timed(name="rest_response_time", description="Time of a request-response interval.", tags={"group=REST", "metric=rest_response_time"}, unit="milliseconds")
public class Api {
    @Inject
    ApiService service;

    @GET
    @Path(value="/schemas")
    @Produces(value={"application/json"})
    public List<SchemaListItem> apiSchemasGet(@Min(value=0L) @DefaultValue(value="0") @QueryParam(value="page") @Min(value=0L) int page, @Min(value=1L) @DefaultValue(value="100") @QueryParam(value="per_page") @Min(value=1L) int perPage) throws ArtifactNotFoundException {
        return this.service.apiSchemasGet(page, perPage);
    }

    @POST
    @Path(value="/schemas")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void apiSchemasPost(@Suspended AsyncResponse response, @NotNull @Valid NewSchema schema, @DefaultValue(value="false") @QueryParam(value="verify") boolean verify, @Context SecurityContext securityContext) throws ArtifactNotFoundException, ArtifactAlreadyExistsException {
        this.service.apiSchemasPost(response, schema, verify);
    }

    @DELETE
    @Path(value="/schemas/{schemaid}")
    @Produces(value={"application/json"})
    public Response apiSchemasSchemaidDelete(@PathParam(value="schemaid") String schemaid) throws ArtifactNotFoundException {
        return this.service.apiSchemasSchemaidDelete(ApiUtil.normalizeSchemaID(schemaid));
    }

    @GET
    @Path(value="/schemas/{schemaid}")
    @Produces(value={"application/json"})
    public SchemaInfo apiSchemasSchemaidGet(@PathParam(value="schemaid") String schemaid) throws ArtifactNotFoundException {
        return this.service.apiSchemasSchemaidGet(ApiUtil.normalizeSchemaID(schemaid));
    }

    @PATCH
    @Path(value="/schemas/{schemaid}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response apiSchemasSchemaidPatch(@PathParam(value="schemaid") String schemaid, @NotNull @Valid List<SchemaModificationPatch> schemaModificationPatches) throws ArtifactNotFoundException {
        return this.service.apiSchemasSchemaidPatch(ApiUtil.normalizeSchemaID(schemaid), schemaModificationPatches);
    }

    @POST
    @Path(value="/schemas/{schemaid}/versions")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void apiSchemasSchemaidVersionsPost(@Suspended AsyncResponse response, @PathParam(value="schemaid") @NotNull String schemaid, @NotNull @Valid NewSchemaVersion schema, @DefaultValue(value="false") @QueryParam(value="verify") boolean verify) throws ArtifactNotFoundException, ArtifactAlreadyExistsException {
        this.service.apiSchemasSchemaidVersionsPost(response, ApiUtil.normalizeSchemaID(schemaid), schema, verify);
    }

    @DELETE
    @Path(value="/schemas/{schemaid}/versions/{versionnum}")
    @Produces(value={"application/json"})
    public Response apiSchemasSchemaidVersionsVersionnumDelete(@PathParam(value="schemaid") String schemaid, @PathParam(value="versionnum") int versionnum) throws ArtifactNotFoundException {
        return this.service.apiSchemasSchemaidVersionsVersionnumDelete(ApiUtil.normalizeSchemaID(schemaid), versionnum);
    }

    @GET
    @Path(value="/schemas/{schemaid}/versions/{versionnum}")
    @Produces(value={"application/json", "application/vnd.apache.avro+json"})
    public Schema apiSchemasSchemaidVersionsVersionnumGet(@PathParam(value="schemaid") String schemaid, @PathParam(value="versionnum") int versionnum) throws ArtifactNotFoundException {
        return this.service.apiSchemasSchemaidVersionsVersionnumGet(ApiUtil.normalizeSchemaID(schemaid), versionnum);
    }

    @PATCH
    @Path(value="/schemas/{schemaid}/versions/{versionnum}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response apiSchemasSchemaidVersionsVersionnumPatch(@PathParam(value="schemaid") String schemaid, @PathParam(value="versionnum") int versionnum, @NotNull @Valid List<SchemaModificationPatch> schemaModificationPatches) throws ArtifactNotFoundException {
        return this.service.apiSchemasSchemaidVersionsVersionnumPatch(ApiUtil.normalizeSchemaID(schemaid), versionnum, schemaModificationPatches);
    }
}

