/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ibmcompat.api.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.ibmcompat.api.ApiService;
import io.apicurio.registry.ibmcompat.api.impl.ApiUtil;
import io.apicurio.registry.ibmcompat.model.EnabledModification;
import io.apicurio.registry.ibmcompat.model.NewSchema;
import io.apicurio.registry.ibmcompat.model.NewSchemaVersion;
import io.apicurio.registry.ibmcompat.model.Schema;
import io.apicurio.registry.ibmcompat.model.SchemaInfo;
import io.apicurio.registry.ibmcompat.model.SchemaListItem;
import io.apicurio.registry.ibmcompat.model.SchemaModificationPatch;
import io.apicurio.registry.ibmcompat.model.SchemaState;
import io.apicurio.registry.ibmcompat.model.SchemaSummary;
import io.apicurio.registry.ibmcompat.model.SchemaVersion;
import io.apicurio.registry.ibmcompat.model.StateModification;
import io.apicurio.registry.logging.Logged;
import io.apicurio.registry.rules.RuleApplicationType;
import io.apicurio.registry.rules.RulesService;
import io.apicurio.registry.rules.validity.InvalidContentException;
import io.apicurio.registry.storage.ArtifactAlreadyExistsException;
import io.apicurio.registry.storage.ArtifactMetaDataDto;
import io.apicurio.registry.storage.ArtifactNotFoundException;
import io.apicurio.registry.storage.ArtifactVersionMetaDataDto;
import io.apicurio.registry.storage.EditableArtifactMetaDataDto;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.StoredArtifact;
import io.apicurio.registry.storage.VersionNotFoundException;
import io.apicurio.registry.types.ArtifactState;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.util.ArtifactIdGenerator;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Response;
import org.jetbrains.annotations.Nullable;

@ApplicationScoped
@Logged
public class ApiServiceImpl
implements ApiService {
    @Inject
    @Current
    RegistryStorage storage;
    @Inject
    RulesService rulesService;
    @Inject
    ArtifactIdGenerator idGenerator;
    private static final String SCHEMA_NAME_ADDITIONAL_PROPERTY = "ibmcompat-schema-name";
    private static final String SCHEMA_STATE_COMMENT_ADDITIONAL_PROPERTY = "ibmcompat-schema-state-comment";

    private List<SchemaVersion> getSchemaVersions(String schemaid) {
        return this.storage.getArtifactVersions(schemaid).stream().map(versionid -> this.getSchemaVersionFromStorage(schemaid, (Long)versionid)).filter(schemaVersion -> schemaVersion != null).collect(Collectors.toList());
    }

    private SchemaVersion getLatestSchemaVersion(String schemaid) {
        return this.getSchemaVersionFromStorage(schemaid, this.storage.getArtifact(schemaid).getVersion());
    }

    private SchemaVersion getSchemaVersionFromStorage(String schemaid, Long versionid) {
        SchemaVersion schemaVersion = null;
        try {
            ArtifactVersionMetaDataDto avmdd = this.storage.getArtifactVersionMetaData(schemaid, versionid);
            schemaVersion = this.getSchemaVersion(avmdd.getVersion(), avmdd.getName(), avmdd.getCreatedOn(), avmdd.getState(), avmdd.getDescription());
        }
        catch (ArtifactNotFoundException artifactNotFoundException) {
            // empty catch block
        }
        return schemaVersion;
    }

    private SchemaVersion getSchemaVersion(int id, String name, long createdOn, ArtifactState state, String description) {
        SchemaVersion schemaVersion = new SchemaVersion();
        schemaVersion.setId(id);
        schemaVersion.setDate(new Date(createdOn));
        schemaVersion.setName(name);
        schemaVersion.setEnabled(!ArtifactState.DISABLED.equals((Object)state));
        SchemaState versionState = new SchemaState();
        if (ArtifactState.DEPRECATED.equals((Object)state)) {
            versionState.setState(SchemaState.StateEnum.DEPRECATED);
        } else {
            versionState.setState(SchemaState.StateEnum.ACTIVE);
        }
        if (description != null) {
            versionState.setComment(description);
        }
        schemaVersion.setState(versionState);
        return schemaVersion;
    }

    private void populateSchemaSummary(String schemaid, SchemaSummary schemaSummary) {
        List versionStates = this.storage.getArtifactVersions(schemaid).stream().map(version -> this.storage.getArtifactVersionMetaData(schemaid, (long)version).getState()).collect(Collectors.toList());
        Map<String, String> properties = this.storage.getArtifactMetaData(schemaid).getProperties();
        schemaSummary.setId(schemaid);
        boolean isSchemaDisabled = versionStates.stream().allMatch(versionState -> ArtifactState.DISABLED.equals(versionState));
        schemaSummary.setEnabled(!isSchemaDisabled);
        boolean isSchemaDeprecated = versionStates.stream().allMatch(versionState -> ArtifactState.DEPRECATED.equals(versionState));
        SchemaState schemaState = new SchemaState();
        if (isSchemaDeprecated) {
            schemaState.setState(SchemaState.StateEnum.DEPRECATED);
        } else {
            schemaState.setState(SchemaState.StateEnum.ACTIVE);
        }
        schemaSummary.setState(schemaState);
        if (properties != null) {
            schemaSummary.setName(properties.getOrDefault(SCHEMA_NAME_ADDITIONAL_PROPERTY, schemaid));
            schemaState.setComment(properties.get(SCHEMA_STATE_COMMENT_ADDITIONAL_PROPERTY));
        } else {
            schemaSummary.setName(schemaid);
        }
    }

    private SchemaInfo getSchemaInfo(ArtifactMetaDataDto amdd) {
        SchemaInfo schemaInfo = new SchemaInfo();
        schemaInfo.setId(amdd.getId());
        schemaInfo.setEnabled(true);
        SchemaState schemaState = new SchemaState();
        schemaState.setState(SchemaState.StateEnum.ACTIVE);
        schemaInfo.setState(schemaState);
        Map<String, String> properties = amdd.getProperties();
        if (properties != null) {
            schemaInfo.setName(properties.getOrDefault(SCHEMA_NAME_ADDITIONAL_PROPERTY, amdd.getId()));
            schemaState.setComment(properties.get(SCHEMA_STATE_COMMENT_ADDITIONAL_PROPERTY));
        } else {
            schemaInfo.setName(amdd.getId());
        }
        return schemaInfo;
    }

    private void handleArtifactCreation(AsyncResponse response, String artifactId, ArtifactMetaDataDto amdd, Throwable t) {
        if (t != null) {
            if (t instanceof CompletionException) {
                t = ((CompletionException)t).getCause();
            }
            response.resume(t);
            return;
        }
        SchemaInfo info = this.getSchemaInfo(amdd);
        ArrayList<SchemaVersion> schemaVersions = new ArrayList<SchemaVersion>();
        info.setVersions(schemaVersions);
        try {
            schemaVersions.addAll(this.getSchemaVersions(artifactId));
            if (schemaVersions.isEmpty() || amdd.getVersion() != ((SchemaVersion)schemaVersions.get(schemaVersions.size() - 1)).getId().intValue()) {
                schemaVersions.add(this.getSchemaVersion(amdd.getVersion(), amdd.getName(), amdd.getCreatedOn(), amdd.getState(), null));
            } else {
                ((SchemaVersion)schemaVersions.get(schemaVersions.size() - 1)).setName(amdd.getName());
            }
        }
        catch (ArtifactNotFoundException anfe) {
            schemaVersions.add(this.getSchemaVersion(amdd.getVersion(), amdd.getName(), amdd.getCreatedOn(), amdd.getState(), null));
        }
        catch (Throwable throwable) {
            response.resume(t);
            return;
        }
        response.resume((Object)Response.status((Response.Status)Response.Status.CREATED).entity((Object)info).build());
    }

    @Nullable
    private ArtifactState getPatchedArtifactState(List<SchemaModificationPatch> schemaModificationPatches) {
        ArtifactState artifactState = null;
        boolean isEnabled = true;
        boolean isDeprecated = false;
        for (SchemaModificationPatch schemaModificationPatch : schemaModificationPatches) {
            if (schemaModificationPatch instanceof EnabledModification) {
                isEnabled = ((EnabledModification)schemaModificationPatch).getValue();
                continue;
            }
            if (!(schemaModificationPatch instanceof StateModification) || ArtifactState.DISABLED.equals((Object)artifactState)) continue;
            isDeprecated = SchemaState.StateEnum.DEPRECATED.equals((Object)((StateModification)schemaModificationPatch).getValue().getState());
        }
        artifactState = !isEnabled ? ArtifactState.DISABLED : (isDeprecated ? ArtifactState.DEPRECATED : ArtifactState.ENABLED);
        return artifactState;
    }

    @Nullable
    private String getPatchedArtifactStateComment(List<SchemaModificationPatch> schemaModificationPatches) {
        String comment = null;
        for (SchemaModificationPatch schemaModificationPatch : schemaModificationPatches) {
            if (!(schemaModificationPatch instanceof StateModification)) continue;
            comment = ((StateModification)schemaModificationPatch).getValue().getComment();
        }
        return comment;
    }

    private void setSchemaVersionState(ArtifactState artifactState, SchemaVersion version) {
        if (ArtifactState.DISABLED.equals((Object)artifactState)) {
            version.setEnabled(false);
        } else if (ArtifactState.ENABLED.equals((Object)artifactState)) {
            version.setEnabled(true);
        } else if (ArtifactState.DEPRECATED.equals((Object)artifactState)) {
            version.getState().setState(SchemaState.StateEnum.DEPRECATED);
        }
    }

    private void updateArtifactVersionState(String schemaid, int versionnum, ArtifactState artifactState) {
        ArtifactVersionMetaDataDto avmdd = this.storage.getArtifactVersionMetaData(schemaid, versionnum);
        if (artifactState != null && !artifactState.equals((Object)avmdd.getState())) {
            this.storage.updateArtifactState(schemaid, artifactState, versionnum);
        }
    }

    private void handleVerifiedArtifact(AsyncResponse response, ContentHandle content) {
        String verifiedContent;
        try {
            verifiedContent = new ObjectMapper().writeValueAsString((Object)content.content());
        }
        catch (JsonProcessingException e) {
            throw new InvalidContentException(e);
        }
        response.resume((Object)Response.ok().entity((Object)verifiedContent).build());
    }

    @Override
    public List<SchemaListItem> apiSchemasGet(int page, int perPage) throws ArtifactNotFoundException {
        TreeSet<String> ids = new TreeSet<String>(this.storage.getArtifactIds(null));
        return ids.stream().skip(page * perPage).limit(perPage).map(id -> {
            SchemaListItem item = new SchemaListItem();
            try {
                this.populateSchemaSummary((String)id, item);
                item.setLatest(this.getLatestSchemaVersion((String)id));
            }
            catch (ArtifactNotFoundException e) {
                return null;
            }
            return item;
        }).filter(item -> item != null).collect(Collectors.toList());
    }

    @Override
    public void apiSchemasPost(AsyncResponse response, NewSchema schema, boolean verify) throws ArtifactNotFoundException, ArtifactAlreadyExistsException {
        String artifactId;
        String schemaName = schema.getName();
        if (schemaName == null) {
            schemaName = artifactId = this.idGenerator.generate();
        } else {
            artifactId = ApiUtil.normalizeSchemaID(schemaName);
        }
        ContentHandle content = ContentHandle.create(schema.getDefinition());
        this.rulesService.applyRules(artifactId, ArtifactType.AVRO, content, RuleApplicationType.CREATE);
        if (verify) {
            this.handleVerifiedArtifact(response, content);
        } else {
            EditableArtifactMetaDataDto dto = new EditableArtifactMetaDataDto();
            dto.setName(schema.getVersion());
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put(SCHEMA_NAME_ADDITIONAL_PROPERTY, schemaName);
            dto.setProperties(properties);
            this.storage.createArtifactWithMetadata(artifactId, ArtifactType.AVRO, content, dto).whenComplete((amdd, t) -> this.handleArtifactCreation(response, artifactId, (ArtifactMetaDataDto)amdd, (Throwable)t));
        }
    }

    @Override
    public Response apiSchemasSchemaidDelete(String schemaid) throws ArtifactNotFoundException {
        SortedSet<Long> ids = this.storage.deleteArtifact(schemaid);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).entity(ids).build();
    }

    @Override
    public SchemaInfo apiSchemasSchemaidGet(String schemaid) throws ArtifactNotFoundException {
        SchemaInfo info = new SchemaInfo();
        this.populateSchemaSummary(schemaid, info);
        info.setVersions(this.getSchemaVersions(schemaid));
        return info;
    }

    @Override
    public Response apiSchemasSchemaidPatch(String schemaid, List<SchemaModificationPatch> schemaModificationPatches) throws ArtifactNotFoundException {
        String schemaStateComment;
        ArtifactState artifactState = this.getPatchedArtifactState(schemaModificationPatches);
        if (artifactState != null) {
            for (Long versionid : this.storage.getArtifactVersions(schemaid)) {
                this.updateArtifactVersionState(schemaid, versionid.intValue(), artifactState);
            }
        }
        if ((schemaStateComment = this.getPatchedArtifactStateComment(schemaModificationPatches)) != null) {
            this.updateStateCommentInArtifactMetadata(schemaid, schemaStateComment);
        }
        SchemaInfo info = new SchemaInfo();
        this.populateSchemaSummary(schemaid, info);
        info.setVersions(this.getSchemaVersions(schemaid));
        if (ArtifactState.DISABLED.equals((Object)artifactState)) {
            info.setEnabled(false);
        } else if (ArtifactState.ENABLED.equals((Object)artifactState)) {
            info.setEnabled(true);
        } else if (ArtifactState.DEPRECATED.equals((Object)artifactState)) {
            info.getState().setState(SchemaState.StateEnum.DEPRECATED);
            if (schemaStateComment != null) {
                info.getState().setComment(schemaStateComment);
            }
            info.setEnabled(true);
        }
        for (SchemaVersion version : info.getVersions()) {
            this.setSchemaVersionState(artifactState, version);
        }
        return Response.ok().entity((Object)info).build();
    }

    private void updateStateCommentInArtifactMetadata(String schemaid, String schemaStateComment) {
        ArtifactMetaDataDto amdd = this.storage.getArtifactMetaData(schemaid);
        Map<String, String> properties = amdd.getProperties();
        if (properties == null) {
            properties = new HashMap<String, String>();
        }
        properties.put(SCHEMA_STATE_COMMENT_ADDITIONAL_PROPERTY, schemaStateComment);
        EditableArtifactMetaDataDto dto = EditableArtifactMetaDataDto.builder().name(amdd.getName()).description(amdd.getDescription()).labels(amdd.getLabels()).properties(properties).build();
        this.storage.updateArtifactMetaData(schemaid, dto);
    }

    @Override
    public void apiSchemasSchemaidVersionsPost(AsyncResponse response, String schemaid, NewSchemaVersion newSchemaVersion, boolean verify) throws ArtifactNotFoundException, ArtifactAlreadyExistsException {
        ContentHandle body = ContentHandle.create(newSchemaVersion.getDefinition());
        this.rulesService.applyRules(schemaid, ArtifactType.AVRO, body, RuleApplicationType.UPDATE);
        if (verify) {
            this.handleVerifiedArtifact(response, body);
        } else {
            EditableArtifactMetaDataDto dto = new EditableArtifactMetaDataDto();
            dto.setName(newSchemaVersion.getVersion());
            this.storage.updateArtifactWithMetadata(schemaid, ArtifactType.AVRO, body, dto).whenComplete((amdd, t) -> this.handleArtifactCreation(response, schemaid, (ArtifactMetaDataDto)amdd, (Throwable)t));
        }
    }

    @Override
    public Response apiSchemasSchemaidVersionsVersionnumDelete(String schemaid, int versionnum) throws ArtifactNotFoundException {
        this.storage.deleteArtifactVersion(schemaid, versionnum);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @Override
    public Schema apiSchemasSchemaidVersionsVersionnumGet(String schemaid, int versionnum) throws ArtifactNotFoundException {
        Schema schema = new Schema();
        this.populateSchemaSummary(schemaid, schema);
        StoredArtifact artifact = this.storage.getArtifactVersion(schemaid, versionnum);
        schema.setDefinition(artifact.getContent().content());
        schema.setVersion(this.getSchemaVersionFromStorage(schemaid, artifact.getVersion()));
        return schema;
    }

    @Override
    public Response apiSchemasSchemaidVersionsVersionnumPatch(String schemaid, int versionnum, List<SchemaModificationPatch> schemaModificationPatches) throws ArtifactNotFoundException {
        ArtifactState artifactState = this.getPatchedArtifactState(schemaModificationPatches);
        this.updateArtifactVersionState(schemaid, versionnum, artifactState);
        String schemaVersionStateComment = this.getPatchedArtifactStateComment(schemaModificationPatches);
        if (schemaVersionStateComment != null) {
            ArtifactVersionMetaDataDto avmdd = this.storage.getArtifactVersionMetaData(schemaid, versionnum);
            EditableArtifactMetaDataDto dto = EditableArtifactMetaDataDto.builder().name(avmdd.getName()).description(schemaVersionStateComment).build();
            this.storage.updateArtifactVersionMetaData(schemaid, versionnum, dto);
        }
        SchemaInfo info = new SchemaInfo();
        this.populateSchemaSummary(schemaid, info);
        info.setVersions(this.getSchemaVersions(schemaid));
        SchemaVersion schemaVersion = info.getVersions().stream().filter(version -> versionnum == version.getId()).findFirst().orElseThrow(() -> new VersionNotFoundException(schemaid, versionnum));
        this.setSchemaVersionState(artifactState, schemaVersion);
        return Response.ok().entity((Object)info).build();
    }
}

