/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.metrics;

import io.apicurio.registry.metrics.PersistenceExceptionLivenessInterceptor;
import io.apicurio.registry.rest.RegistryExceptionMapper;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class LivenessUtil {
    private static final Logger log = LoggerFactory.getLogger(PersistenceExceptionLivenessInterceptor.class);
    @Inject
    @ConfigProperty(name="registry.liveness.errors.ignored")
    List<String> ignored;

    public boolean isIgnoreError(Throwable ex) {
        boolean ignored = this.isIgnored(ex);
        if (ignored) {
            log.debug("Ignored intercepted exception: " + ex.getClass().getName() + " :: " + ex.getMessage());
        }
        return ignored;
    }

    private boolean isIgnored(Throwable ex) {
        Set<Class<? extends Exception>> ignoredClasses = RegistryExceptionMapper.getIgnored();
        if (ignoredClasses.contains(ex.getClass())) {
            return true;
        }
        return this.ignored != null && this.ignored.contains(ex.getClass().getName());
    }
}

