/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.metrics;

import io.apicurio.registry.metrics.PersistenceTimeoutReadinessApply;
import io.apicurio.registry.metrics.PersistenceTimeoutReadinessCheck;
import java.time.Instant;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;

@Interceptor
@PersistenceTimeoutReadinessApply
public class PersistenceTimeoutReadinessInterceptor {
    @Inject
    PersistenceTimeoutReadinessCheck check;

    @AroundInvoke
    public Object intercept(InvocationContext context) throws Exception {
        Instant start = Instant.now();
        Object result = context.proceed();
        if (start.plus(this.check.getTimeoutSec()).isBefore(Instant.now())) {
            this.check.suspectSuper();
        }
        return result;
    }
}

