/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.metrics;

import io.apicurio.registry.metrics.AbstractErrorCounterHealthCheck;
import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Default;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.Provider;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.Readiness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Readiness
@Default
@Provider
public class ResponseTimeoutReadinessCheck
extends AbstractErrorCounterHealthCheck
implements HealthCheck,
ContainerRequestFilter,
ContainerResponseFilter {
    private static final Logger log = LoggerFactory.getLogger(ResponseTimeoutReadinessCheck.class);
    private static final String HEADER_NAME = "X-Apicurio-Registry-ResponseTimeoutReadinessCheck-RequestStart";
    @ConfigProperty(name="registry.metrics.ResponseTimeoutReadinessCheck.errorThreshold", defaultValue="1")
    Integer configErrorThreshold;
    @ConfigProperty(name="registry.metrics.ResponseTimeoutReadinessCheck.counterResetWindowDurationSec", defaultValue="60")
    Integer configCounterResetWindowDurationSec;
    @ConfigProperty(name="registry.metrics.ResponseTimeoutReadinessCheck.statusResetWindowDurationSec", defaultValue="300")
    Integer configStatusResetWindowDurationSec;
    @ConfigProperty(name="registry.metrics.ResponseTimeoutReadinessCheck.timeoutSec", defaultValue="10")
    Integer configTimeoutSec;
    private Duration timeoutSec;

    @PostConstruct
    void init() {
        this.init(this.configErrorThreshold, this.configCounterResetWindowDurationSec, this.configStatusResetWindowDurationSec);
        this.timeoutSec = Duration.ofSeconds(this.configTimeoutSec.intValue());
    }

    public void filter(ContainerRequestContext requestContext) {
        requestContext.getHeaders().putSingle((Object)HEADER_NAME, (Object)Instant.now().toString());
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        String requestStart = requestContext.getHeaderString(HEADER_NAME);
        if (requestStart != null) {
            try {
                if (Instant.parse(requestStart).plus(this.timeoutSec).isBefore(Instant.now())) {
                    this.suspectSuper();
                }
            }
            catch (DateTimeParseException ex) {
                log.error("Value '{}' of header '{}' is the wrong format!", (Object)requestStart, (Object)HEADER_NAME);
            }
        } else {
            log.warn("Expected header '{}' not found.", (Object)HEADER_NAME);
        }
    }

    public synchronized HealthCheckResponse call() {
        this.callSuper();
        return HealthCheckResponse.builder().name("ResponseTimeoutReadinessCheck").withData("errorCount", this.errorCounter).state(this.up).build();
    }
}

