/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.logging.Logged;
import io.apicurio.registry.metrics.ResponseErrorLivenessCheck;
import io.apicurio.registry.metrics.ResponseTimeoutReadinessCheck;
import io.apicurio.registry.metrics.RestMetricsApply;
import io.apicurio.registry.rest.ArtifactsResource;
import io.apicurio.registry.rest.Headers;
import io.apicurio.registry.rest.HeadersHack;
import io.apicurio.registry.rest.beans.ArtifactMetaData;
import io.apicurio.registry.rest.beans.EditableMetaData;
import io.apicurio.registry.rest.beans.IfExistsType;
import io.apicurio.registry.rest.beans.Rule;
import io.apicurio.registry.rest.beans.UpdateState;
import io.apicurio.registry.rest.beans.VersionMetaData;
import io.apicurio.registry.rules.RuleApplicationType;
import io.apicurio.registry.rules.RulesService;
import io.apicurio.registry.search.client.SearchClient;
import io.apicurio.registry.search.common.Search;
import io.apicurio.registry.storage.ArtifactAlreadyExistsException;
import io.apicurio.registry.storage.ArtifactMetaDataDto;
import io.apicurio.registry.storage.ArtifactNotFoundException;
import io.apicurio.registry.storage.ArtifactVersionMetaDataDto;
import io.apicurio.registry.storage.EditableArtifactMetaDataDto;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.RuleConfigurationDto;
import io.apicurio.registry.storage.StoredArtifact;
import io.apicurio.registry.storage.VersionNotFoundException;
import io.apicurio.registry.types.ArtifactMediaTypes;
import io.apicurio.registry.types.ArtifactState;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.util.ArtifactIdGenerator;
import io.apicurio.registry.util.ArtifactTypeUtil;
import io.apicurio.registry.util.ContentTypeUtil;
import io.apicurio.registry.util.DtoUtil;
import io.apicurio.registry.utils.ProtoUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.interceptor.Interceptors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.metrics.annotation.ConcurrentGauge;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Timed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Interceptors(value={ResponseErrorLivenessCheck.class, ResponseTimeoutReadinessCheck.class})
@RestMetricsApply
@Counted(name="rest_request_count", description="Total number of REST requests.", tags={"group=REST", "metric=rest_request_count"}, reusable=true)
@ConcurrentGauge(name="concurrent_request_count", description="Number of concurrent REST requests.", tags={"group=REST", "metric=concurrent_request_count"}, reusable=true)
@Timed(name="rest_response_time", description="Time of a request-response interval.", tags={"group=REST", "metric=rest_response_time"}, unit="milliseconds", reusable=true)
@Logged
public class ArtifactsResourceImpl
implements ArtifactsResource,
Headers {
    private static final Logger log = LoggerFactory.getLogger(ArtifactsResourceImpl.class);
    private static final String EMPTY_CONTENT_ERROR_MESSAGE = "Empty content is not allowed.";
    @Inject
    @Current
    RegistryStorage storage;
    @Inject
    RulesService rulesService;
    @Inject
    ArtifactIdGenerator idGenerator;
    @Context
    HttpServletRequest request;
    @Inject
    @Current
    SearchClient searchClient;
    private static final int GET_ARTIFACT_IDS_LIMIT = 10000;

    private String getContentType() {
        return this.request.getContentType();
    }

    private static ArtifactType determineArtifactType(ContentHandle content, ArtifactType xArtifactType, String ct) {
        ArtifactType artifactType = xArtifactType;
        if (artifactType == null && (artifactType = ArtifactsResourceImpl.getArtifactTypeFromContentType(ct)) == null) {
            artifactType = ArtifactTypeUtil.discoverType(content, ct);
        }
        return artifactType;
    }

    private static ArtifactType getArtifactTypeFromContentType(String contentType) {
        String[] split;
        if (contentType != null && contentType.contains("application/json") && contentType.indexOf(59) != -1 && (split = contentType.split(";")).length > 1) {
            for (String s : split) {
                if (!s.contains("artifactType=")) continue;
                String at = s.split("=")[1];
                try {
                    return ArtifactType.valueOf((String)at);
                }
                catch (IllegalArgumentException e) {
                    throw new BadRequestException("Unsupported artifact type: " + at);
                }
            }
        }
        if (contentType != null && contentType.contains("x-proto")) {
            return ArtifactType.PROTOBUF;
        }
        if (contentType != null && contentType.contains("graphql")) {
            return ArtifactType.GRAPHQL;
        }
        return null;
    }

    private CompletionStage<ArtifactMetaData> indexArtifact(String artifactId, ContentHandle content, ArtifactMetaData amdd) throws CompletionException {
        try {
            Search.Artifact artifact = Search.Artifact.newBuilder().setArtifactId(artifactId).setContent(content.content()).setVersion((long)amdd.getVersion().intValue()).setGlobalId(amdd.getGlobalId().longValue()).setName(ProtoUtil.nullAsEmpty((String)amdd.getName())).setDescription(ProtoUtil.nullAsEmpty((String)amdd.getDescription())).setCreatedBy(ProtoUtil.nullAsEmpty((String)amdd.getCreatedBy())).build();
            return this.searchClient.index(artifact).whenComplete((sr, t) -> {
                if (t != null) {
                    log.error("Artifact {}/{} not indexed, error: {}", new Object[]{artifactId, amdd.getVersion(), t.getMessage()});
                } else if (sr.ok()) {
                    log.info("Artifact {}/{} successfully indexed", (Object)artifactId, (Object)amdd.getVersion());
                } else {
                    log.warn("Artifact {}/{} not indexed, status: {}", new Object[]{artifactId, amdd.getVersion(), sr.status()});
                }
            }).thenApply(sr -> amdd);
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private CompletionStage<ArtifactMetaData> handleIfExists(ArtifactType artifactType, String artifactId, IfExistsType ifExists, ContentHandle content, String ct) {
        ArtifactMetaData artifactMetaData = this.getArtifactMetaData(artifactId);
        switch (ifExists) {
            case UPDATE: {
                return this.updateArtifactInternal(artifactId, artifactType, content, ct);
            }
            case RETURN: {
                return CompletableFuture.completedFuture(artifactMetaData);
            }
            case RETURN_OR_UPDATE: {
                return this.handleIfExistsReturnOrUpdate(artifactId, artifactType, content, ct);
            }
        }
        throw new ArtifactAlreadyExistsException(artifactId);
    }

    private CompletionStage<ArtifactMetaData> handleIfExistsReturnOrUpdate(String artifactId, ArtifactType artifactType, ContentHandle content, String ct) {
        try {
            ArtifactMetaDataDto mdDto = this.storage.getArtifactMetaData(artifactId, content);
            ArtifactMetaData md = DtoUtil.dtoToMetaData(artifactId, artifactType, mdDto);
            return CompletableFuture.completedFuture(md);
        }
        catch (ArtifactNotFoundException artifactNotFoundException) {
            return this.updateArtifactInternal(artifactId, artifactType, content, ct);
        }
    }

    public void checkIfDeprecated(Supplier<ArtifactState> stateSupplier, String artifactId, Number version, Response.ResponseBuilder builder) {
        HeadersHack.checkIfDeprecated(stateSupplier, artifactId, version, builder);
    }

    public void updateArtifactState(String artifactId, UpdateState data) {
        Objects.requireNonNull(artifactId);
        Objects.requireNonNull(data.getState());
        this.storage.updateArtifactState(artifactId, data.getState());
    }

    public List<String> listArtifacts() {
        return new ArrayList<String>(this.storage.getArtifactIds(10000));
    }

    public void updateArtifactVersionState(Integer version, String artifactId, UpdateState data) {
        Objects.requireNonNull(artifactId);
        Objects.requireNonNull(data.getState());
        Objects.requireNonNull(version);
        this.storage.updateArtifactState(artifactId, data.getState(), version);
    }

    public void testUpdateArtifact(String artifactId, ArtifactType xRegistryArtifactType, InputStream data) {
        Objects.requireNonNull(artifactId);
        ContentHandle content = ContentHandle.create(data);
        if (content.bytes().length == 0) {
            throw new BadRequestException(EMPTY_CONTENT_ERROR_MESSAGE);
        }
        String ct = this.getContentType();
        if (ContentTypeUtil.isApplicationYaml(ct)) {
            content = ContentTypeUtil.yamlToJson(content);
        }
        ArtifactType artifactType = ArtifactsResourceImpl.determineArtifactType(content, xRegistryArtifactType, ct);
        this.rulesService.applyRules(artifactId, artifactType, content, RuleApplicationType.UPDATE);
    }

    public CompletionStage<ArtifactMetaData> createArtifact(ArtifactType xRegistryArtifactType, String xRegistryArtifactId, IfExistsType ifExists, InputStream data) {
        ContentHandle content = ContentHandle.create(data);
        if (content.bytes().length == 0) {
            throw new BadRequestException(EMPTY_CONTENT_ERROR_MESSAGE);
        }
        String ct = this.getContentType();
        ContentHandle finalContent = content;
        try {
            String artifactId = xRegistryArtifactId;
            if (artifactId == null || artifactId.trim().isEmpty()) {
                artifactId = this.idGenerator.generate();
            }
            if (ContentTypeUtil.isApplicationYaml(ct)) {
                content = ContentTypeUtil.yamlToJson(content);
            }
            ArtifactType artifactType = ArtifactsResourceImpl.determineArtifactType(content, xRegistryArtifactType, ct);
            this.rulesService.applyRules(artifactId, artifactType, content, RuleApplicationType.CREATE);
            String finalArtifactId = artifactId;
            return this.storage.createArtifact(artifactId, artifactType, content).exceptionally(t -> {
                if (t instanceof CompletionException) {
                    t = t.getCause();
                }
                if (t instanceof ArtifactAlreadyExistsException) {
                    return null;
                }
                throw new CompletionException((Throwable)t);
            }).thenCompose(amd -> amd == null ? this.handleIfExists(xRegistryArtifactType, xRegistryArtifactId, ifExists, finalContent, ct) : CompletableFuture.completedFuture(DtoUtil.dtoToMetaData(finalArtifactId, artifactType, amd))).thenCompose(amdd -> this.indexArtifact(finalArtifactId, finalContent, (ArtifactMetaData)amdd));
        }
        catch (ArtifactAlreadyExistsException ex) {
            return this.handleIfExists(xRegistryArtifactType, xRegistryArtifactId, ifExists, content, ct).thenCompose(amdd -> this.indexArtifact(xRegistryArtifactId, finalContent, (ArtifactMetaData)amdd));
        }
    }

    public Response getLatestArtifact(String artifactId) {
        ArtifactMetaDataDto metaData = this.storage.getArtifactMetaData(artifactId);
        if (ArtifactState.DISABLED.equals((Object)metaData.getState())) {
            throw new ArtifactNotFoundException(artifactId);
        }
        StoredArtifact artifact = this.storage.getArtifact(artifactId);
        MediaType contentType = ArtifactMediaTypes.JSON;
        if (metaData.getType() == ArtifactType.PROTOBUF) {
            contentType = ArtifactMediaTypes.PROTO;
        }
        if (metaData.getType() == ArtifactType.GRAPHQL) {
            contentType = ArtifactMediaTypes.GRAPHQL;
        }
        if (metaData.getType() == ArtifactType.WSDL || metaData.getType() == ArtifactType.XSD || metaData.getType() == ArtifactType.XML) {
            contentType = ArtifactMediaTypes.XML;
        }
        Response.ResponseBuilder builder = Response.ok((Object)artifact.getContent(), (MediaType)contentType);
        this.checkIfDeprecated(metaData::getState, artifactId, metaData.getVersion(), builder);
        return builder.build();
    }

    private CompletionStage<ArtifactMetaData> updateArtifactInternal(String artifactId, ArtifactType xRegistryArtifactType, ContentHandle content, String ct) {
        Objects.requireNonNull(artifactId);
        if (ContentTypeUtil.isApplicationYaml(ct)) {
            content = ContentTypeUtil.yamlToJson(content);
        }
        ArtifactType artifactType = ArtifactsResourceImpl.determineArtifactType(content, xRegistryArtifactType, ct);
        this.rulesService.applyRules(artifactId, artifactType, content, RuleApplicationType.UPDATE);
        return this.storage.updateArtifact(artifactId, artifactType, content).thenApply(dto -> DtoUtil.dtoToMetaData(artifactId, artifactType, dto));
    }

    public CompletionStage<ArtifactMetaData> updateArtifact(String artifactId, ArtifactType xRegistryArtifactType, InputStream data) {
        ContentHandle content = ContentHandle.create(data);
        if (content.bytes().length == 0) {
            throw new BadRequestException(EMPTY_CONTENT_ERROR_MESSAGE);
        }
        return this.updateArtifactInternal(artifactId, xRegistryArtifactType, content, this.getContentType()).thenCompose(amdd -> this.indexArtifact(artifactId, content, (ArtifactMetaData)amdd));
    }

    public void deleteArtifact(String artifactId) {
        this.storage.deleteArtifact(artifactId);
    }

    public List<Long> listArtifactVersions(String artifactId) {
        SortedSet<Long> versions = this.storage.getArtifactVersions(artifactId);
        return new ArrayList<Long>(versions);
    }

    public CompletionStage<VersionMetaData> createArtifactVersion(String artifactId, ArtifactType xRegistryArtifactType, InputStream data) {
        Objects.requireNonNull(artifactId);
        ContentHandle content = ContentHandle.create(data);
        if (content.bytes().length == 0) {
            throw new BadRequestException(EMPTY_CONTENT_ERROR_MESSAGE);
        }
        String ct = this.getContentType();
        if (ContentTypeUtil.isApplicationYaml(ct)) {
            content = ContentTypeUtil.yamlToJson(content);
        }
        ArtifactType artifactType = ArtifactsResourceImpl.determineArtifactType(content, xRegistryArtifactType, ct);
        this.rulesService.applyRules(artifactId, artifactType, content, RuleApplicationType.UPDATE);
        ContentHandle finalContent = content;
        return this.storage.updateArtifact(artifactId, artifactType, content).thenCompose(amdd -> this.indexArtifact(artifactId, finalContent, DtoUtil.dtoToMetaData(artifactId, artifactType, amdd))).thenApply(amd -> DtoUtil.dtoToVersionMetaData(artifactId, artifactType, amd));
    }

    public Response getArtifactVersion(Integer version, String artifactId) {
        ArtifactVersionMetaDataDto metaData = this.storage.getArtifactVersionMetaData(artifactId, version.intValue());
        if (ArtifactState.DISABLED.equals((Object)metaData.getState())) {
            throw new VersionNotFoundException(artifactId, version.intValue());
        }
        StoredArtifact artifact = this.storage.getArtifactVersion(artifactId, version.intValue());
        MediaType contentType = ArtifactMediaTypes.JSON;
        if (metaData.getType() == ArtifactType.PROTOBUF) {
            contentType = ArtifactMediaTypes.PROTO;
        }
        if (metaData.getType() == ArtifactType.GRAPHQL) {
            contentType = ArtifactMediaTypes.GRAPHQL;
        }
        if (metaData.getType() == ArtifactType.WSDL || metaData.getType() == ArtifactType.XSD || metaData.getType() == ArtifactType.XML) {
            contentType = ArtifactMediaTypes.XML;
        }
        Response.ResponseBuilder builder = Response.ok((Object)artifact.getContent(), (MediaType)contentType);
        this.checkIfDeprecated(metaData::getState, artifactId, version, builder);
        return builder.build();
    }

    public List<RuleType> listArtifactRules(String artifactId) {
        return this.storage.getArtifactRules(artifactId);
    }

    public void createArtifactRule(String artifactId, Rule data) {
        RuleConfigurationDto config = new RuleConfigurationDto();
        config.setConfiguration(data.getConfig());
        this.storage.createArtifactRule(artifactId, data.getType(), config);
    }

    public void deleteArtifactRules(String artifactId) {
        this.storage.deleteArtifactRules(artifactId);
    }

    public Rule getArtifactRuleConfig(RuleType rule, String artifactId) {
        RuleConfigurationDto dto = this.storage.getArtifactRule(artifactId, rule);
        Rule rval = new Rule();
        rval.setConfig(dto.getConfiguration());
        rval.setType(rule);
        return rval;
    }

    public Rule updateArtifactRuleConfig(RuleType rule, String artifactId, Rule data) {
        RuleConfigurationDto dto = new RuleConfigurationDto(data.getConfig());
        this.storage.updateArtifactRule(artifactId, rule, dto);
        Rule rval = new Rule();
        rval.setType(rule);
        rval.setConfig(data.getConfig());
        return rval;
    }

    public void deleteArtifactRule(RuleType rule, String artifactId) {
        this.storage.deleteArtifactRule(artifactId, rule);
    }

    public ArtifactMetaData getArtifactMetaData(String artifactId) {
        ArtifactMetaDataDto dto = this.storage.getArtifactMetaData(artifactId);
        return DtoUtil.dtoToMetaData(artifactId, dto.getType(), dto);
    }

    public ArtifactMetaData getArtifactMetaDataByContent(String artifactId, InputStream data) {
        ContentHandle content = ContentHandle.create(data);
        if (content.bytes().length == 0) {
            throw new BadRequestException(EMPTY_CONTENT_ERROR_MESSAGE);
        }
        if (ContentTypeUtil.isApplicationYaml(this.getContentType())) {
            content = ContentTypeUtil.yamlToJson(content);
        }
        ArtifactMetaDataDto dto = this.storage.getArtifactMetaData(artifactId, content);
        return DtoUtil.dtoToMetaData(artifactId, dto.getType(), dto);
    }

    public void updateArtifactMetaData(String artifactId, EditableMetaData data) {
        EditableArtifactMetaDataDto dto = new EditableArtifactMetaDataDto();
        dto.setName(data.getName());
        dto.setDescription(data.getDescription());
        dto.setLabels(data.getLabels());
        dto.setProperties(data.getProperties());
        this.storage.updateArtifactMetaData(artifactId, dto);
    }

    public VersionMetaData getArtifactVersionMetaData(Integer version, String artifactId) {
        ArtifactVersionMetaDataDto dto = this.storage.getArtifactVersionMetaData(artifactId, version.intValue());
        return DtoUtil.dtoToVersionMetaData(artifactId, dto.getType(), dto);
    }

    public void updateArtifactVersionMetaData(Integer version, String artifactId, EditableMetaData data) {
        EditableArtifactMetaDataDto dto = new EditableArtifactMetaDataDto();
        dto.setName(data.getName());
        dto.setDescription(data.getDescription());
        this.storage.updateArtifactVersionMetaData(artifactId, version.longValue(), dto);
    }

    public void deleteArtifactVersionMetaData(Integer version, String artifactId) {
        this.storage.deleteArtifactVersionMetaData(artifactId, version.intValue());
    }
}

