/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest;

import io.apicurio.registry.logging.Logged;
import io.apicurio.registry.metrics.ResponseErrorLivenessCheck;
import io.apicurio.registry.metrics.ResponseTimeoutReadinessCheck;
import io.apicurio.registry.metrics.RestMetricsApply;
import io.apicurio.registry.rest.RulesResource;
import io.apicurio.registry.rest.beans.Rule;
import io.apicurio.registry.rules.DefaultRuleDeletionException;
import io.apicurio.registry.rules.RulesProperties;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.RuleConfigurationDto;
import io.apicurio.registry.storage.RuleNotFoundException;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.types.RuleType;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.interceptor.Interceptors;
import org.eclipse.microprofile.metrics.annotation.ConcurrentGauge;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Timed;

@ApplicationScoped
@Interceptors(value={ResponseErrorLivenessCheck.class, ResponseTimeoutReadinessCheck.class})
@RestMetricsApply
@Counted(name="rest_request_count", description="Total number of REST requests.", tags={"group=REST", "metric=rest_request_count"})
@ConcurrentGauge(name="concurrent_request_count", description="Number of concurrent REST requests.", tags={"group=REST", "metric=concurrent_request_count"})
@Timed(name="rest_response_time", description="Time of a request-response interval.", tags={"group=REST", "metric=rest_response_time"}, unit="milliseconds")
@Logged
public class RulesResourceImpl
implements RulesResource {
    @Inject
    @Current
    RegistryStorage storage;
    @Inject
    RulesProperties rulesProperties;

    public List<RuleType> listGlobalRules() {
        List<RuleType> rules = this.storage.getGlobalRules();
        List<RuleType> defaultRules = this.rulesProperties.getFilteredDefaultGlobalRules(rules);
        return Stream.concat(rules.stream(), defaultRules.stream()).sorted().collect(Collectors.toList());
    }

    public void createGlobalRule(Rule data) {
        RuleConfigurationDto configDto = new RuleConfigurationDto();
        configDto.setConfiguration(data.getConfig());
        this.storage.createGlobalRule(data.getType(), configDto);
    }

    public void deleteAllGlobalRules() {
        this.storage.deleteGlobalRules();
    }

    public Rule getGlobalRuleConfig(RuleType rule) {
        RuleConfigurationDto dto;
        block2: {
            try {
                dto = this.storage.getGlobalRule(rule);
            }
            catch (RuleNotFoundException ruleNotFoundException) {
                dto = this.rulesProperties.getDefaultGlobalRuleConfiguration(rule);
                if (dto != null) break block2;
                throw ruleNotFoundException;
            }
        }
        Rule ruleBean = new Rule();
        ruleBean.setType(rule);
        ruleBean.setConfig(dto.getConfiguration());
        return ruleBean;
    }

    public Rule updateGlobalRuleConfig(RuleType rule, Rule data) {
        RuleConfigurationDto configDto = new RuleConfigurationDto();
        configDto.setConfiguration(data.getConfig());
        try {
            this.storage.updateGlobalRule(rule, configDto);
        }
        catch (RuleNotFoundException ruleNotFoundException) {
            if (this.rulesProperties.isDefaultGlobalRuleConfigured(rule)) {
                this.storage.createGlobalRule(rule, configDto);
            }
            throw ruleNotFoundException;
        }
        Rule ruleBean = new Rule();
        ruleBean.setType(rule);
        ruleBean.setConfig(data.getConfig());
        return ruleBean;
    }

    public void deleteGlobalRule(RuleType rule) {
        try {
            this.storage.deleteGlobalRule(rule);
        }
        catch (RuleNotFoundException ruleNotFoundException) {
            if (this.rulesProperties.isDefaultGlobalRuleConfigured(rule)) {
                throw new DefaultRuleDeletionException(rule);
            }
            throw ruleNotFoundException;
        }
    }
}

