/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules;

import io.apicurio.registry.rules.RulesProperties;
import io.apicurio.registry.storage.RuleConfigurationDto;
import io.apicurio.registry.types.RuleType;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;

public class RulesPropertiesImpl
implements RulesProperties {
    private final Properties properties;
    private final Map<RuleType, String> defaultGlobalRules;

    public RulesPropertiesImpl(Properties properties) {
        this.properties = properties;
        this.defaultGlobalRules = properties.stringPropertyNames().stream().collect(Collectors.toMap(rulePropertyName -> RuleType.fromValue((String)rulePropertyName.toUpperCase()), properties::getProperty));
    }

    @Override
    public List<RuleType> getFilteredDefaultGlobalRules(List<RuleType> excludeRulesFilter) {
        return this.defaultGlobalRules.keySet().stream().filter(ruleType -> excludeRulesFilter == null || !excludeRulesFilter.contains(ruleType)).collect(Collectors.toList());
    }

    @Override
    public boolean isDefaultGlobalRuleConfigured(RuleType ruleType) {
        return this.defaultGlobalRules.containsKey(ruleType);
    }

    @Override
    public RuleConfigurationDto getDefaultGlobalRuleConfiguration(RuleType ruleType) {
        RuleConfigurationDto ruleConfigurationDto = null;
        if (this.defaultGlobalRules.containsKey(ruleType)) {
            ruleConfigurationDto = new RuleConfigurationDto();
            ruleConfigurationDto.setConfiguration(this.defaultGlobalRules.get(ruleType));
        }
        return ruleConfigurationDto;
    }
}

