/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.compatibility;

import io.apicurio.registry.common.proto.Serde;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.rules.compatibility.CompatibilityChecker;
import io.apicurio.registry.rules.compatibility.CompatibilityLevel;
import java.util.List;
import java.util.Objects;

public class ProtobufFdCompatibilityChecker
implements CompatibilityChecker {
    @Override
    public boolean isCompatibleWith(CompatibilityLevel compatibilityLevel, List<ContentHandle> existingArtifacts, ContentHandle proposedArtifact) {
        Objects.requireNonNull(compatibilityLevel, "compatibilityLevel MUST NOT be null");
        Objects.requireNonNull(existingArtifacts, "existingSchemas MUST NOT be null");
        Objects.requireNonNull(proposedArtifact, "proposedSchema MUST NOT be null");
        try {
            Serde.Schema.parseFrom((byte[])proposedArtifact.bytes());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean isCompatibleWith(CompatibilityLevel compatibilityLevel, List<String> existingSchemas, String proposedSchema) {
        throw new UnsupportedOperationException("String content not supported!");
    }
}

