/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.compatibility.jsonschema.diff;

import io.apicurio.registry.rules.compatibility.jsonschema.diff.DiffType;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.Difference;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.everit.json.schema.SchemaLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiffContext {
    private static final Logger log = LoggerFactory.getLogger(DiffContext.class);
    private final Set<Difference> diff = new HashSet<Difference>();
    private DiffContext parentContext;
    private DiffContext rootContext;
    private final String pathUpdated;
    final Set<SchemaLocation> visited = new HashSet<SchemaLocation>();

    private DiffContext(DiffContext rootContext, DiffContext parentContext, String pathUpdated) {
        this.rootContext = rootContext;
        this.parentContext = parentContext;
        this.pathUpdated = pathUpdated;
        if (parentContext != null) {
            this.visited.addAll(parentContext.visited);
        }
    }

    public DiffContext sub(String pathFragmentUpdated) {
        return new DiffContext(this.rootContext, this, this.pathUpdated + "/" + pathFragmentUpdated);
    }

    private void initRootContext(DiffContext rootContext) {
        if (this.rootContext != null || this.parentContext != null) {
            throw new IllegalStateException();
        }
        this.rootContext = rootContext;
        this.parentContext = rootContext;
    }

    public static DiffContext createRootContext(String basePathFragmentUpdated) {
        DiffContext rootContext = new DiffContext(null, null, basePathFragmentUpdated);
        rootContext.initRootContext(rootContext);
        return rootContext;
    }

    public static DiffContext createRootContext() {
        return DiffContext.createRootContext("");
    }

    private void addToDifferenceSets(Difference difference) {
        this.diff.add(difference);
        if (this.rootContext != this) {
            this.parentContext.addToDifferenceSets(difference);
        }
    }

    public void addDifference(DiffType type, Object originalSubchema, Object updatedSubchema) {
        Difference difference = Difference.builder().diffType(type).pathOriginal("").pathUpdated(this.pathUpdated).subSchemaOriginal(Objects.toString(originalSubchema)).subSchemaUpdated(Objects.toString(updatedSubchema)).build();
        this.addToDifferenceSets(difference);
    }

    public void log(String message) {
        log.debug("[Context path (updated): {}]{}", (Object)this.pathUpdated, (Object)message);
    }

    public Set<Difference> getDiff() {
        return new HashSet<Difference>(this.diff);
    }

    public boolean foundIncompatibleDifference() {
        return this.diff.stream().anyMatch(d -> !d.getDiffType().isBackwardsCompatible());
    }

    public boolean foundAllDifferencesAreCompatible() {
        return !this.foundIncompatibleDifference();
    }

    public String toString() {
        return "DiffContext { foundAllDifferencesAreCompatible = " + this.foundAllDifferencesAreCompatible() + ", diff = " + this.diff + ", pathAtUpdated = '" + this.pathUpdated + "' }";
    }

    public String getPathUpdated() {
        return this.pathUpdated;
    }
}

