/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.compatibility.jsonschema.diff;

import io.apicurio.registry.rules.compatibility.jsonschema.JsonSchemaWrapperVisitor;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.DiffContext;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.DiffType;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.DiffUtil;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.NumberSchemaWrapper;
import java.math.BigDecimal;
import org.everit.json.schema.NumberSchema;

public class NumberSchemaDiffVisitor
extends JsonSchemaWrapperVisitor {
    private final DiffContext ctx;
    private final NumberSchema original;
    private NumberSchemaWrapper schema;

    public NumberSchemaDiffVisitor(DiffContext ctx, NumberSchema original) {
        this.ctx = ctx;
        this.original = original;
    }

    @Override
    public void visitNumberSchema(NumberSchemaWrapper schema) {
        this.schema = schema;
        super.visitNumberSchema(schema);
    }

    @Override
    public void visitRequiredInteger(boolean requiresInteger) {
        boolean originalRequiresInteger = this.original.requiresInteger();
        if (this.original.getMultipleOf() != null) {
            BigDecimal multipleOf = new BigDecimal(this.original.getMultipleOf().toString());
            BigDecimal one = new BigDecimal("1");
            originalRequiresInteger = originalRequiresInteger || multipleOf.compareTo(one) == 0;
        }
        DiffUtil.diffBooleanTransition(this.ctx.sub("requiresInteger"), originalRequiresInteger, requiresInteger, false, DiffType.NUMBER_TYPE_INTEGER_REQUIRED_FALSE_TO_TRUE, DiffType.NUMBER_TYPE_INTEGER_REQUIRED_TRUE_TO_FALSE, DiffType.NUMBER_TYPE_INTEGER_REQUIRED_UNCHANGED);
        super.visitRequiredInteger(requiresInteger);
    }

    @Override
    public void visitMinimum(Number minimum) {
        Number updatedMinimum;
        boolean isOriginalMinimumExclusive = this.original.getExclusiveMinimumLimit() != null;
        Number originalMinimum = isOriginalMinimumExclusive ? (Number)this.original.getExclusiveMinimumLimit() : (Number)this.original.getMinimum();
        boolean isUpdatedMinimumExclusive = this.schema.getExclusiveMinimumLimit() != null;
        Number number = updatedMinimum = isUpdatedMinimumExclusive ? (Number)this.schema.getExclusiveMinimumLimit() : (Number)this.schema.getMinimum();
        if (DiffUtil.diffNumber(this.ctx.sub("minimum"), originalMinimum, updatedMinimum, DiffType.NUMBER_TYPE_MINIMUM_ADDED, DiffType.NUMBER_TYPE_MINIMUM_REMOVED, DiffType.NUMBER_TYPE_MINIMUM_INCREASED, DiffType.NUMBER_TYPE_MINIMUM_DECREASED)) {
            DiffUtil.diffBooleanTransition(this.ctx.sub("exclusiveMinimum"), isOriginalMinimumExclusive, isUpdatedMinimumExclusive, false, DiffType.NUMBER_TYPE_IS_MINIMUM_EXCLUSIVE_FALSE_TO_TRUE, DiffType.NUMBER_TYPE_IS_MINIMUM_EXCLUSIVE_TRUE_TO_FALSE, DiffType.NUMBER_TYPE_IS_MINIMUM_EXCLUSIVE_UNCHANGED);
        }
        super.visitMinimum(minimum);
    }

    @Override
    public void visitExclusiveMinimum(boolean exclusiveMinimum) {
        DiffUtil.diffBooleanTransition(this.ctx.sub("exclusiveMinimum"), this.original.isExclusiveMinimum(), exclusiveMinimum, false, DiffType.NUMBER_TYPE_IS_MINIMUM_EXCLUSIVE_FALSE_TO_TRUE, DiffType.NUMBER_TYPE_IS_MINIMUM_EXCLUSIVE_TRUE_TO_FALSE, DiffType.NUMBER_TYPE_IS_MINIMUM_EXCLUSIVE_UNCHANGED);
        super.visitExclusiveMinimum(exclusiveMinimum);
    }

    @Override
    public void visitExclusiveMinimumLimit(Number exclusiveMinimumLimit) {
        super.visitExclusiveMinimumLimit(exclusiveMinimumLimit);
    }

    @Override
    public void visitMaximum(Number maximum) {
        Number updatedMaximum;
        boolean isOriginalMaximumExclusive = this.original.getExclusiveMaximumLimit() != null;
        Number originalMaximum = isOriginalMaximumExclusive ? (Number)this.original.getExclusiveMaximumLimit() : (Number)this.original.getMaximum();
        boolean isUpdatedMaximumExclusive = this.schema.getExclusiveMaximumLimit() != null;
        Number number = updatedMaximum = isUpdatedMaximumExclusive ? (Number)this.schema.getExclusiveMaximumLimit() : (Number)this.schema.getMaximum();
        if (DiffUtil.diffNumber(this.ctx.sub("maximum"), originalMaximum, updatedMaximum, DiffType.NUMBER_TYPE_MAXIMUM_ADDED, DiffType.NUMBER_TYPE_MAXIMUM_REMOVED, DiffType.NUMBER_TYPE_MAXIMUM_INCREASED, DiffType.NUMBER_TYPE_MAXIMUM_DECREASED)) {
            DiffUtil.diffBooleanTransition(this.ctx.sub("exclusiveMaximum"), isOriginalMaximumExclusive, isUpdatedMaximumExclusive, false, DiffType.NUMBER_TYPE_IS_MAXIMUM_EXCLUSIVE_FALSE_TO_TRUE, DiffType.NUMBER_TYPE_IS_MAXIMUM_EXCLUSIVE_TRUE_TO_FALSE, DiffType.NUMBER_TYPE_IS_MAXIMUM_EXCLUSIVE_UNCHANGED);
        }
        super.visitMaximum(maximum);
    }

    @Override
    public void visitExclusiveMaximum(boolean exclusiveMaximum) {
        DiffUtil.diffBooleanTransition(this.ctx.sub("exclusiveMaximum"), this.original.isExclusiveMaximum(), exclusiveMaximum, false, DiffType.NUMBER_TYPE_IS_MAXIMUM_EXCLUSIVE_FALSE_TO_TRUE, DiffType.NUMBER_TYPE_IS_MAXIMUM_EXCLUSIVE_TRUE_TO_FALSE, DiffType.NUMBER_TYPE_IS_MAXIMUM_EXCLUSIVE_UNCHANGED);
        super.visitExclusiveMaximum(exclusiveMaximum);
    }

    @Override
    public void visitExclusiveMaximumLimit(Number exclusiveMaximumLimit) {
        super.visitExclusiveMaximumLimit(exclusiveMaximumLimit);
    }

    @Override
    public void visitMultipleOf(Number multipleOf) {
        DiffContext subCtx = this.ctx.sub("multipleOf");
        if (DiffUtil.diffAddedRemoved(subCtx, this.original.getMultipleOf(), multipleOf, DiffType.NUMBER_TYPE_MULTIPLE_OF_ADDED, DiffType.NUMBER_TYPE_MULTIPLE_OF_REMOVED)) {
            DiffUtil.diffNumberOriginalMultipleOfUpdated(subCtx, this.original.getMultipleOf(), multipleOf, DiffType.NUMBER_TYPE_MULTIPLE_OF_UPDATED_IS_DIVISIBLE, DiffType.NUMBER_TYPE_MULTIPLE_OF_UPDATED_IS_NOT_DIVISIBLE);
        }
        super.visitMultipleOf(multipleOf);
    }
}

