/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.registry.storage.ArtifactMetaDataDto;
import io.apicurio.registry.storage.ArtifactStateExt;
import io.apicurio.registry.storage.ArtifactVersionMetaDataDto;
import io.apicurio.registry.types.ArtifactType;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;

public class MetaDataKeys {
    public static String ARTIFACT_ID = "artifact_id";
    public static String CONTENT = "content";
    public static String GLOBAL_ID = "global_id";
    public static String VERSION = "version";
    public static String NAME = "name";
    public static String TYPE = "type";
    public static String DESCRIPTION = "description";
    public static String CREATED_BY = "createdBy";
    public static String CREATED_ON = "createdOn";
    public static String MODIFIED_BY = "modifiedBy";
    public static String MODIFIED_ON = "modifiedOn";
    public static String STATE = "state";
    public static String LABELS = "labels";
    public static String PROPERTIES = "properties";
    public static String DELETED = "_deleted";
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static ArtifactMetaDataDto toArtifactMetaData(Map<String, String> content) {
        ArtifactMetaDataDto dto = new ArtifactMetaDataDto();
        dto.setId(content.get(ARTIFACT_ID));
        String createdOn = content.get(CREATED_ON);
        String modifiedOn = content.get(MODIFIED_ON);
        dto.setCreatedBy(content.get(CREATED_BY));
        if (createdOn != null) {
            dto.setCreatedOn(Long.parseLong(createdOn));
        }
        dto.setModifiedBy(content.get(MODIFIED_BY));
        if (modifiedOn != null) {
            dto.setModifiedOn(Long.parseLong(modifiedOn));
        }
        dto.setDescription(content.get(DESCRIPTION));
        dto.setName(content.get(NAME));
        dto.setType(ArtifactType.fromValue((String)content.get(TYPE)));
        dto.setVersion(Integer.parseInt(content.get(VERSION)));
        dto.setGlobalId(Long.parseLong(content.get(GLOBAL_ID)));
        dto.setState(ArtifactStateExt.getState(content));
        if (content.get(LABELS) != null) {
            dto.setLabels(Arrays.asList(content.get(LABELS).split(",")));
        }
        if (content.get(PROPERTIES) != null) {
            try {
                dto.setProperties((Map)MAPPER.readValue(content.get(PROPERTIES), Map.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        return dto;
    }

    public static ArtifactVersionMetaDataDto toArtifactVersionMetaData(Map<String, String> content) {
        ArtifactVersionMetaDataDto dto = new ArtifactVersionMetaDataDto();
        String createdOn = content.get(CREATED_ON);
        if (createdOn != null) {
            dto.setCreatedOn(Long.parseLong(createdOn));
        }
        dto.setCreatedBy(content.get(CREATED_BY));
        dto.setDescription(content.get(DESCRIPTION));
        dto.setName(content.get(NAME));
        dto.setType(ArtifactType.fromValue((String)content.get(TYPE)));
        dto.setVersion(Integer.parseInt(content.get(VERSION)));
        dto.setGlobalId(Long.parseLong(content.get(GLOBAL_ID)));
        dto.setState(ArtifactStateExt.getState(content));
        if (content.get(LABELS) != null) {
            dto.setLabels(Arrays.asList(content.get(LABELS).split(",")));
        }
        if (content.get(PROPERTIES) != null) {
            try {
                dto.setProperties((Map)MAPPER.readValue(content.get(PROPERTIES), Map.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        return dto;
    }

    public static byte[] getContent(Map<String, String> cMap) {
        String encoded = cMap.get(CONTENT);
        if (encoded == null) {
            return null;
        }
        return Base64.getDecoder().decode(encoded);
    }

    public static void putContent(Map<String, String> cMap, byte[] content) {
        cMap.put(CONTENT, Base64.getEncoder().encodeToString(content));
    }
}

