/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import io.apicurio.registry.common.proto.Serde;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.rules.compatibility.ProtobufFile;
import io.apicurio.registry.storage.InvalidArtifactTypeException;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.util.DocumentBuilderAccessor;
import java.io.InputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class ArtifactTypeUtil {
    private static final ObjectMapper mapper = new ObjectMapper();

    private ArtifactTypeUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ArtifactType discoverType(ContentHandle content, String contentType) throws InvalidArtifactTypeException {
        boolean triedProto = false;
        if (contentType == null || contentType.toLowerCase().contains("proto")) {
            triedProto = true;
            ArtifactType type = ArtifactTypeUtil.tryProto(content);
            if (type != null) {
                return type;
            }
        }
        try {
            JsonNode tree = mapper.readTree(content.content());
            if (tree.has("openapi")) return ArtifactType.OPENAPI;
            if (tree.has("swagger")) {
                return ArtifactType.OPENAPI;
            }
            if (tree.has("asyncapi")) {
                return ArtifactType.ASYNCAPI;
            }
            if (tree.has("$schema") && tree.get("$schema").asText().contains("json-schema.org")) {
                return ArtifactType.JSON;
            }
            if (!tree.has("type")) throw new InvalidArtifactTypeException("Failed to discover artifact type from JSON content.");
            return ArtifactType.AVRO;
        }
        catch (Exception tree) {
            ArtifactType type;
            if (!triedProto && (type = ArtifactTypeUtil.tryProto(content)) != null) {
                return type;
            }
            if (ArtifactTypeUtil.tryGraphQL(content)) {
                return ArtifactType.GRAPHQL;
            }
            try (InputStream stream = content.stream();){
                Document xmlDocument = DocumentBuilderAccessor.getDocumentBuilder().parse(stream);
                Element root = xmlDocument.getDocumentElement();
                String ns = root.getNamespaceURI();
                if (ns != null && ns.equals("http://www.w3.org/2001/XMLSchema")) {
                    ArtifactType artifactType = ArtifactType.XSD;
                    return artifactType;
                }
                if (ns != null && (ns.equals("http://schemas.xmlsoap.org/wsdl/") || ns.equals("http://www.w3.org/ns/wsdl/"))) {
                    ArtifactType artifactType = ArtifactType.WSDL;
                    return artifactType;
                }
                ArtifactType artifactType = ArtifactType.XML;
                return artifactType;
            }
            catch (Exception exception) {
                throw new InvalidArtifactTypeException("Failed to discover artifact type from content.");
            }
        }
    }

    private static ArtifactType tryProto(ContentHandle content) {
        try {
            ProtobufFile.toProtoFileElement(content.content());
            return ArtifactType.PROTOBUF;
        }
        catch (Exception exception) {
            try {
                Serde.Schema.parseFrom((byte[])content.bytes());
                return ArtifactType.PROTOBUF_FD;
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }

    private static boolean tryGraphQL(ContentHandle content) {
        try {
            TypeDefinitionRegistry typeRegistry = new SchemaParser().parse(content.content());
            if (typeRegistry != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

