/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.auth;

import io.apicurio.registry.auth.RoleProvider;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.types.RoleType;
import io.quarkus.security.identity.SecurityIdentity;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class StorageRoleProvider
implements RoleProvider {
    @Inject
    SecurityIdentity securityIdentity;
    @Inject
    @Current
    RegistryStorage storage;

    private boolean hasRole(String role) {
        String role4principal = this.storage.getRoleForPrincipal(this.securityIdentity.getPrincipal().getName());
        return role.equals(role4principal);
    }

    @Override
    public boolean isDeveloper() {
        return this.hasRole(RoleType.DEVELOPER.name());
    }

    @Override
    public boolean isReadOnly() {
        return this.hasRole(RoleType.READ_ONLY.name());
    }

    @Override
    public boolean isAdmin() {
        return this.hasRole(RoleType.ADMIN.name());
    }
}

